<?php
// index.php - Archivo que maneja el formulario y carga los datos desde la base de datos
session_start();
// Incluir el archivo de conexión
include('db.php');
if ( $_SESSION['usuario_id'] == "") {
    header("Location: index.php");
    exit;
 }
// Definir variables de error (opcional)
$error = '';
// Consultar las rutas desde la base de datos
$sql_rutas = "SELECT Id, Nombre FROM rutas";
$stmt_rutas = $pdo->prepare($sql_rutas);
$stmt_rutas->execute();
$rutas = $stmt_rutas->fetchAll(PDO::FETCH_ASSOC);

// Consultar los vendedores desde la base de datos
$sql_vendedores = "SELECT Id, Nombre FROM vendedores";
$stmt_vendedores = $pdo->prepare($sql_vendedores);
$stmt_vendedores->execute();
$vendedores = $stmt_vendedores->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Obtener valores de los campos del formulario
    $ruta = $_POST['ruta'];
    $vendedor = $_POST['vendedor'];


    // Validar si las variables no están vacías
    if (empty($ruta) || empty($vendedor)) {
        // Si alguna variable está vacía, mostrar un mensaje de error
        $error = "Debe seleccionar tanto una ruta como un vendedor.";
    } else {
        // Si ambas variables tienen valores, hacer algo con los datos (en este caso redirigir a index.php)
        //echo "Ruta seleccionada: $ruta<br>";
        //echo "Vendedor seleccionado: $vendedor<br>";

        $_SESSION['ruta_id'] = $ruta;
        $_SESSION['vendedor_id'] = $vendedor;

        // Redirigir al index.php si la validación fue exitosa
        header("Location: index.php");
        exit; // Es importante usar exit después de header para evitar que el script siga ejecutándose
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <title>Seleccion</title>
</head>
<body>

<div class="container d-flex justify-content-center align-items-center min-vh-100">


    <div class="card" style="width: 100%; max-width: 400px;">
      

        <div class="card-body">


      
            <!-- Mostrar mensaje de error si existe -->
            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="mb-3">
                    <label for="ruta" class="form-label"><b>Ruta</b></label>
                    <select name="ruta" id="ruta" class="form-select">
                        <option value="">Seleccione una Ruta</option>
                        <?php
                        // Llenar las opciones de "Ruta"
                        foreach ($rutas as $ruta) {
                            echo "<option value='".$ruta['Id']."'>".$ruta['Nombre']."</option>";
                        }
                        ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="vendedor" class="form-label"><b>Vendedor</b></label>
                    <select name="vendedor" id="vendedor" class="form-select">
                        <option value="">Seleccione un Vendedor</option>
                        <?php
                        // Llenar las opciones de "Vendedor"
                        foreach ($vendedores as $vendedor) {
                            echo "<option value='".$vendedor['Id']."'>".$vendedor['Nombre']."</option>";
                        }
                        ?>
                    </select>
                </div>

                <button type="submit" class="btn btn-primary w-100">Aceptar</button>
                <button type="reset" class="btn btn-danger w-100 mt-2">Cancelar</button>
            </form>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>