
<?php
include 'db.php';

if (isset($_POST['search_producto'])) {
    $searchTerm = $_POST['search_producto'];
    $stmt = $pdo->prepare("SELECT * FROM productos WHERE Detalle LIKE ?");
    $stmt->execute(['%' . $searchTerm . '%']);
} else {
    $stmt = $pdo->query("SELECT * FROM productos LIMIT 100");
}

$productos = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Productos</title>
    <!-- Incluir Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .container {
            max-width: 900px;
            margin-top: 30px;
        }
        h3 {
            color: #333;
            text-align: center;
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .form-control, .btn {
            font-size: 1rem;
        }
        .btn-info {
            background-color: #17a2b8;
            border-color: #17a2b8;
        }
        .btn-info:hover {
            background-color: #138496;
            border-color: #117a8b;
        }
        .table-striped tbody tr:nth-child(odd) {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>

<div class="container">
    <h3>Lista de Productos</h3>

    <!-- Formulario de búsqueda -->
    <form method="POST" class="mb-4">
        <div class="input-group">
            <input type="text" name="search_producto" class="form-control" placeholder="Buscar producto por detalle" aria-label="Buscar producto" aria-describedby="search-addon">
            <button type="submit" class="btn btn-primary">Buscar</button>
        </div>
    </form>

    <!-- Tabla de productos -->
    <table class="table table-striped table-bordered table-responsive">
        <thead class="table-light">
            <tr>
                <th>Id</th>
                <th>Detalle</th>
                <th>Precio 1</th>
                <th>Precio 2</th>
                <th>Precio 3</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($productos as $producto): ?>
                <tr>
                    <td><?php echo $producto['Id']; ?></td>
                    <td><?php echo $producto['Detalle']; ?></td>
                    <td><?php echo number_format($producto['Precio1'], 2); ?></td>
                    <td><?php echo number_format($producto['Precio2'], 2); ?></td>
                    <td><?php echo number_format($producto['Precio3'], 2); ?></td>
                    <td>
                         <!-- <button class="btn btn-info" onclick="setProducto(<?php echo $producto['Id']; ?>, '<?php echo $producto['Detalle']; ?>', <?php echo $producto['Precio1']; ?>)">Seleccionar</button> -->
                         <!-- <button class="btn btn-info" onclick="setProducto('<?php echo $producto['Id']; ?>', '<?php echo addslashes($producto['Detalle']); ?>', '<?php echo addslashes($producto['Precio1']); ?>')">Seleccionar</button> -->
                        <button class="btn btn-info" onclick="setProducto('<?php echo $producto['Id']; ?>', '<?php echo addslashes($producto['Detalle']); ?>', <?php echo $producto['Precio1']; ?>)">Seleccionar</button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
function setProducto(id, detalle, precio) {
    window.opener.document.getElementById("producto_id").value = String(id);
    //window.opener.document.getElementById("producto_id").value = id;
    //window.opener.document.getElementById("producto_detalle").value = detalle;
    window.opener.document.getElementById("producto_detalle").value = String(detalle);
    window.opener.document.getElementById("producto_precio").value = precio;
    window.close();
}
</script>

<!-- Incluir JS de Bootstrap -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>

</body>
</html>