<?php
session_start();
require_once 'db.php';

if (isset($_POST['login'])) {
    $nombre = $_POST['nombre'];
    $clave = $_POST['clave'];

    // Validar los campos
    if (empty($nombre) || empty($clave)) {
        $error = "Por favor ingrese todos los campos.";
    } else {
        // Consultar si existe el usuario
        $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE Nombre = :nombre AND Clave = :clave");
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':clave', $clave);
        $stmt->execute();

        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($usuario) {
            // Autenticación exitosa
            $_SESSION['usuario_id'] = $usuario['Id'];
            $_SESSION['nombre'] = $usuario['Nombre'];
            $_SESSION['tipo'] = $usuario['Tipo'];
            header("Location: seleccion.php");
            exit();
        } else {
            $error = "Nombre de usuario o contraseña incorrectos.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">   
            <div class="col-md-4">       
                <div class="card">
                    <div class="card-header text-center">   
                        <h3>Iniciar sesión</h3>
                    </div>
                    <div class="card-body">
                        <?php if (isset($error)) { echo '<div class="alert alert-danger">' . $error . '</div>'; } ?>
                        <form method="POST">
                            <div class="mb-3">
                                <label for="nombre" class="form-label">Nombre de usuario</label>
                                <input type="text" id="nombre" name="nombre" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="clave" class="form-label">Contraseña</label>
                                <input type="password" id="clave" name="clave" class="form-control" required>
                            </div>
                            <button type="submit" name="login" class="btn btn-primary w-100">Iniciar sesión</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>