<?php
// Incluir el archivo de conexión a la base de datos (db.php)
require_once 'db.php';

// Establecer el header para devolver JSON
header('Content-Type: application/json');

// Verificar si se pasó el parámetro 'id' en la URL
if (isset($_GET['id'])) {
    $idEstimado = $_GET['id'];

    // Crear la consulta SQL
    $sql = "SELECT estimadodetalle.IdEstimado, estimadodetalle.IdProducto, productos.Detalle, estimadodetalle.Cantidad, estimadodetalle.Importe
            FROM productos 
            INNER JOIN estimado 
            INNER JOIN estimadodetalle 
            ON estimado.Id = estimadodetalle.IdEstimado 
            ON productos.Id = estimadodetalle.IdProducto
            WHERE estimadodetalle.IdEstimado = :idEstimado";

    try {
        // Preparar la consulta
        $stmt = $pdo->prepare($sql);

        // Bindear el parámetro :idEstimado
        $stmt->bindParam(':idEstimado', $idEstimado, PDO::PARAM_INT);

        // Ejecutar la consulta
        $stmt->execute();

        // Verificar si se encontraron resultados
        if ($stmt->rowCount() > 0) {
            // Obtener todos los resultados como un arreglo asociativo
            $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Convertir los resultados a formato JSON y devolverlo
            echo json_encode($resultados, JSON_PRETTY_PRINT);
        } else {
            // Si no hay resultados, devolver un mensaje adecuado
            echo json_encode(["mensaje" => "No se encontraron productos para el estimado especificado"]);
        }
    } catch (PDOException $e) {
        // Manejo de errores si ocurre una excepción
        echo json_encode(["error" => "Error de base de datos: " . $e->getMessage()]);
    }
} else {
    // Si no se pasa el parámetro 'id', devolver un mensaje de error
    echo json_encode(["error" => "El parámetro 'id' es requerido"]);
}
?>