<?php
session_start();
require_once 'dompdf/autoload.inc.php'; // Asegúrate de que la ruta sea correcta a la carpeta de Dompdf
require 'db.php'; // Conexión a la base de datos

// Prevenir que la página se cachee
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

if (!isset($_GET['idEstimado']) || empty($_GET['idEstimado'])) {
    header("Location: error.php"); // Redirigir si no hay ID de estimado
    exit();
}

$id_factura = $_GET['idEstimado'];

// Obtener información de la factura
$sql = "SELECT f.Id, c.NombreComercial AS cliente, c.Direccion, c.Telefono, f.Fecha
        FROM estimado f
        JOIN clientes c ON f.IdCliente = c.Id
        WHERE f.Id = :id_factura";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id_factura' => $id_factura]);
$factura = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener los detalles de los productos
$sql_detalle = "SELECT p.Detalle AS producto, df.Cantidad, p.Precio1, (df.cantidad * p.Precio1) AS total
                FROM estimadodetalle df
                JOIN productos p ON df.IdProducto = p.Id
                WHERE df.IdEstimado = :id_factura";
$stmt_detalle = $pdo->prepare($sql_detalle);
$stmt_detalle->execute(['id_factura' => $id_factura]);
$detalle = $stmt_detalle->fetchAll(PDO::FETCH_ASSOC);

// Incluir Dompdf
use Dompdf\Dompdf;
use Dompdf\Options;

// Crear una instancia de Dompdf
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isPhpEnabled', true);
$dompdf = new Dompdf($options);

// Generar el HTML del contenido
$html = '
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; font-size: 8pt; margin: 0; padding: 0; }
        .container { width: 80mm; margin: 10px auto; }
        .title { text-align: center; font-weight: bold; font-size: 12pt; }
        .details { margin-top: 10px; }
        .details td { padding: 2px 5px; }
        .table { width: 100%; border-collapse: collapse; margin-top: 5px; }
        .table td, .table th { border: 1px solid #000; padding: 4px; text-align: left; font-size: 7pt; }
        .total { margin-top: 10px; text-align: right; font-weight: bold; font-size: 8pt; }
    </style>
</head>
<body>
    <div class="container">
        <div class="title">Factura</div>
        <table class="details">
            <tr><td>Cliente:</td><td>' . $factura['cliente'] . '</td></tr>
            <tr><td>Dirección:</td><td>' . $factura['Direccion'] . '</td></tr>
            <tr><td>Teléfono:</td><td>' . $factura['Telefono'] . '</td></tr>
            <tr><td>Fecha:</td><td>' . $factura['Fecha'] . '</td></tr>
        </table>
        <table class="table">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th>Cant.</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>';

$total_factura = 0;
foreach ($detalle as $row) {
    $html .= '
    <tr>
        <td>' . substr($row['producto'], 0, 17) . '</td>
        <td style="text-align: right;">' . $row['Cantidad'] . '</td>
        <td style="text-align: right;">' . number_format($row['total'], 2) . '</td>
    </tr>';
    $total_factura += $row['total'];
}

$html .= '
            </tbody>
        </table>
        <div class="total">Total Factura: ' . number_format($total_factura, 2) . '</div>
    </div>
</body>
</html>';

// Cargar el HTML a Dompdf
$dompdf->loadHtml($html);

// (Opcional) Establecer el tamaño del papel
$dompdf->setPaper('A4', 'P');

// Renderizar el PDF (este es el paso que realmente lo genera)
$dompdf->render();

// Enviar el PDF al navegador
$dompdf->stream("factura.pdf", array("Attachment" => 0));
?>