<?php

if (!isset($_GET['idEstimado']) || empty($_GET['idEstimado'])) {
    header("Location: error.php"); // Redirigir si no hay ID de estimado
    exit();
}

$id_estimado = $_GET['idEstimado'];

// Incluye el archivo de conexión a la base de datos (asegúrate de usar PDO)
include_once "db.php";

try {
    // Consulta para obtener los datos de la factura
    $sql = "SELECT f.Id, c.NombreComercial AS cliente, c.Direccion, c.Telefono, f.Fecha
            FROM estimado f
            JOIN clientes c ON f.IdCliente = c.Id
            WHERE f.Id = :id_estimado";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['id_estimado' => $id_estimado]);
    $factura = $stmt->fetch(PDO::FETCH_OBJ);

    if (!$factura) {
        exit("No existe estimado con el ID proporcionado.");
    }

    // Consulta para obtener el detalle de los productos
    $sql_detalle = "SELECT p.Detalle AS producto, df.Cantidad, p.Precio1, (df.Cantidad * p.Precio1) AS total
                    FROM estimadodetalle df
                    JOIN productos p ON df.IdProducto = p.Id
                    WHERE df.IdEstimado = :id_estimado";
    $stmt_detalle = $pdo->prepare($sql_detalle);
    $stmt_detalle->execute(['id_estimado' => $id_estimado]);
    $detalle = $stmt_detalle->fetchAll(PDO::FETCH_OBJ);

    if (!$detalle) {
        exit("No hay productos asociados al estimado.");
    }
} catch (PDOException $e) {
    exit("Error en la base de datos: " . $e->getMessage());
}
?>

<style>
    * {
        font-size: 12px;
        font-family: 'Times New Roman';
    }

    td,
    th,
    tr,
    table {
        border-top: 1px solid black;
        border-collapse: collapse;
    }

    td.producto,
    th.producto {
        width: 75px;
        max-width: 75px;
    }

    td.cantidad,
    th.cantidad {
        width: 50px;
        max-width: 50px;
        word-break: break-all;
    }

    td.precio,
    th.precio {
        width: 50px;
        max-width: 50px;
        word-break: break-all;
        text-align: right;
    }

    .centrado {
        text-align: center;
        align-content: center;
    }

    .ticket {
        width: 175px;
        max-width: 175px;
    }

    img {
        max-width: inherit;
        width: inherit;
    }

    @media print {
        .oculto-impresion,
        .oculto-impresion * {
            display: none !important;
        }
    }


    
    @media print {
    @page {
        margin: 0; /* Reduce los márgenes para minimizar encabezados/pies */
    }
    body {
        margin: 0;
        padding: 0;
    }
    }

</style>

<body>
    <div class="ticket">
        <img src="./logo.png" alt="Logotipo">
        <p class="centrado">TICKET DE VENTA
            <br><?php echo htmlspecialchars($factura->Fecha); ?>
        </p>
        <table>
            <thead>
                <tr>
                    <th class="cantidad">CANT</th>
                    <th class="producto">PRODUCTO</th>
                    <th class="precio">TOTAL</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $total = 0;
                foreach ($detalle as $item) {
                    $subtotal = $item->total;
                    $total += $subtotal;
                ?>
                    <tr>
                        <td class="cantidad"><?php echo htmlspecialchars($item->Cantidad); ?></td>
                        <td class="producto"><?php echo htmlspecialchars($item->producto); ?></td>
                        <td class="precio">$<?php echo number_format($subtotal, 2); ?></td>
                    </tr>
                <?php } ?>
                <tr>
                    <td colspan="2" style="text-align: right;">TOTAL</td>
                    <td class="precio">
                        <strong>$<?php echo number_format($total, 2); ?></strong>
                    </td>
                </tr>
            </tbody>
        </table>
        <p class="centrado">¡GRACIAS POR SU COMPRA!</p>



    </div>
</body>

<!-- <script>
    document.addEventListener("DOMContentLoaded", () => {
        window.print();
        setTimeout(() => {
            window.location.href = "estimado.php";
        }, 1000);
    });
</script> -->


<script>
    document.addEventListener("DOMContentLoaded", () => {
        // Inicia la impresión
        window.print();

        // Espera un tiempo breve para asegurarse de que la impresión termine
        setTimeout(() => {
            // Después de la impresión, redirige a otra página o realiza una acción
            window.location.href = "estimado.php"; // Cambia "estimado.php" según lo que necesites
        }, 1000); // 1 segundo de espera
    });
</script>