<?php
session_start();
require('fpdf/fpdf.php');
require('db.php');

// Prevenir que la página se cachee
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// if (!isset($_SESSION['idEstimado']) || empty($_SESSION['idEstimado'])) {
//     header("Location: error.php"); // Redirigir si no hay ID de estimado
//     exit();
// }

// $id_factura = $_SESSION['idEstimado'];  // Obtener el ID de la factura

if (!isset($_GET['id_estimado']) || empty($_GET['id_estimado'])) {
    header("Location: error.php"); // Redirigir si no hay ID de estimado
    exit();
}

$id_factura = $_GET['id_estimado'];


// Obtener información de la factura
$sql = "SELECT f.Id, c.NombreComercial AS cliente, c.Direccion, c.Telefono, f.Fecha
        FROM estimado f
        JOIN clientes c ON f.IdCliente = c.Id
        WHERE f.Id = :id_factura";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id_factura' => $id_factura]);
$factura = $stmt->fetch(PDO::FETCH_ASSOC);

// Obtener los detalles de los productos
$sql_detalle = "SELECT p.Detalle AS producto, df.Cantidad, p.Precio1, (df.cantidad * p.Precio1) AS total
                FROM estimadodetalle df
                JOIN productos p ON df.IdProducto = p.Id
                WHERE df.IdEstimado = :id_factura";
$stmt_detalle = $pdo->prepare($sql_detalle);
$stmt_detalle->execute(['id_factura' => $id_factura]);
$detalle = $stmt_detalle->fetchAll(PDO::FETCH_ASSOC);






// Crear el objeto PDF con el tamaño de página para 80mm de ancho
$pdf = new FPDF('P', 'mm', array(80, 297)); // Orientación 'P' para vertical, tamaño 80mm x 297mm
$pdf->AddPage();

// Ajuste de márgenes
$pdf->SetMargins(2, 2, 2);  // Márgenes pequeños para aprovechar el espacio

// Ajuste de fuentes
$pdf->SetFont('Arial', 'B', 8); // Fuente más pequeña para que se ajuste al ancho del tiquete

// Título de la factura
$pdf->Cell(50, 8, 'Factura', 0, 1, 'C');

// Información del cliente
$pdf->SetFont('Arial', '', 7);
$pdf->Cell(80, 5, 'Cliente: ' . $factura['cliente'], 0, 1);
$pdf->Cell(80, 5, 'Direccion: ' . $factura['Direccion'], 0, 1);
$pdf->Cell(80, 5, 'Telefono: ' . $factura['Telefono'], 0, 1);

// Información de la factura
$pdf->Cell(80, 5, 'Fecha: ' . $factura['Fecha'], 0, 1);

// Detalles de los productos
$pdf->Ln(5);
$pdf->SetFont('Arial', 'B', 7);
$pdf->Cell(30, 5, 'Producto', 1, 0, 'C');
$pdf->Cell(10, 5, 'Cant.', 1, 0, 'C');
$pdf->Cell(20, 5, 'Total', 1, 1, 'C');

// Detalle de cada producto
$pdf->SetFont('Arial', '', 7);
$total_factura = 0;
foreach ($detalle as $row) {
    $pdf->Cell(30, 5, substr($row['producto'], 0, 17), 1, 0, 'L');
    $pdf->Cell(10, 5, $row['Cantidad'], 1, 0, 'R');
    $pdf->Cell(20, 5, number_format($row['total'], 2), 1, 1, 'R');
    $total_factura += $row['total'];
}

// Total general
$pdf->Ln(5);
$pdf->SetFont('Arial', 'B', 7);
$pdf->Cell(40, 5, 'Total Factura:', 0, 0, 'R');
$pdf->Cell(20, 5, number_format($total_factura, 2), 1, 1, 'R');

// Mostrar el PDF en el navegador
$pdf->Output('I', 'factura.pdf'); // Esto mostrará el PDF en el navegador



?>


