<?php
include 'db.php';

if (isset($_POST['search_cliente'])) {
    $searchTerm = $_POST['search_cliente'];
    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE NombreComercial LIKE ?");
    $stmt->execute(['%' . $searchTerm . '%']);
} else {
    $stmt = $pdo->query("SELECT * FROM clientes");
}

$clientes = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Clientes</title>
    <!-- Incluir Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .container {
            max-width: 900px;
            margin-top: 30px;
        }
        h3 {
            color: #333;
            text-align: center;
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .form-control, .btn {
            font-size: 1rem;
        }
        .btn-info {
            background-color: #17a2b8;
            border-color: #17a2b8;
        }
        .btn-info:hover {
            background-color: #138496;
            border-color: #117a8b;
        }
        .table-striped tbody tr:nth-child(odd) {
            background-color: #f2f2f2;
        }
        .input-group {
            margin-bottom: 15px;
        }
    </style>
</head>
<body>

<div class="container">
    <h3>Lista de Clientes</h3>

    <!-- Formulario de búsqueda -->
    <form method="POST" class="mb-4">
        <div class="input-group">
            <input type="text" name="search_cliente" class="form-control" placeholder="Buscar cliente por nombre" aria-label="Buscar cliente" aria-describedby="search-addon">
            <button type="submit" class="btn btn-primary">Buscar</button>
        </div>
    </form>

    <!-- Tabla de clientes -->
    <table class="table table-striped table-bordered table-responsive">
        <thead class="table-light">
            <tr>
                <th>Id</th>
                <th>Nombre</th>
                <th>Precio</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($clientes as $cliente): ?>
                <tr>
                    <td><?php echo $cliente['Id']; ?></td>
                    <td><?php echo $cliente['NombreComercial']; ?></td>
                    <td><?php echo $cliente['Precio']; ?></td>
                    <td>
                        <button class="btn btn-info" onclick="setCliente(<?php echo $cliente['Id']; ?>, '<?php echo $cliente['NombreComercial']; ?>')">Seleccionar</button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>



<!--   
 <script>
 function setCliente(id, nombre) {
     window.opener.document.getElementById("cliente_id").value = id;
     window.opener.document.getElementById("cliente_nombre").value = nombre;
    window.close();
 }
 </script>  -->





 <script>
 function setCliente(id, nombre) {
     // Establece los valores en los campos del formulario de la ventana principal
     window.opener.document.getElementById("cliente_id").value = id;
     window.opener.document.getElementById("cliente_nombre").value = nombre;

     // Envía los datos a PHP usando AJAX (se usará el método POST)
     var xhr = new XMLHttpRequest();
     xhr.open("POST", "guardar_cliente.php", true);
     xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");

     // Envía los datos id y nombre al archivo PHP
     xhr.send("id=" + id + "&nombre=" + nombre);

     // Cierra la ventana emergente
     window.close();
 }
</script>




<!-- Incluir JS de Bootstrap -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>

</body>
</html>