<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos
if (!isset($data['Id'], $data['Nombre'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

$id = $data['Id'];
$nombre = $data['Nombre'];


// Comprobar si existe el registro por el Id
$sql = "SELECT * FROM vendedores WHERE Id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id' => $id]);

$vendedor = $stmt->fetch(PDO::FETCH_ASSOC);

if ($vendedor) {
    // Si el usuario existe, actualizamos los datos
    $sql = "UPDATE vendedores SET Nombre = :nombre WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'nombre' => $nombre,     
        'id' => $id
    ]);
    echo json_encode(['mensaje' => 'vendedor actualizado correctamente']);
} else {
    // Si el usuario no existe, lo insertamos
    $sql = "INSERT INTO vendedores (Id, Nombre) VALUES (:id, :nombre)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id' => $id,
        'nombre' => $nombre,
      
    ]);
    echo json_encode(['mensaje' => 'vendedor insertado correctamente']);
}
?>