<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos
if (!isset($data['Id'], $data['Nombre'], $data['Clave'], $data['Tipo'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

$id = $data['Id'];
$nombre = $data['Nombre'];
$clave = $data['Clave'];
$tipo = $data['Tipo'];

// Comprobar si existe el registro por el Id
$sql = "SELECT * FROM usuarios WHERE Id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id' => $id]);

$usuario = $stmt->fetch(PDO::FETCH_ASSOC);

if ($usuario) {
    // Si el usuario existe, actualizamos los datos
    $sql = "UPDATE usuarios SET Nombre = :nombre, Clave = :clave, Tipo = :tipo WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'nombre' => $nombre,
        'clave' => $clave,
        'tipo' => $tipo,
        'id' => $id
    ]);
    echo json_encode(['mensaje' => 'Usuario actualizado correctamente']);
} else {
    // Si el usuario no existe, lo insertamos
    $sql = "INSERT INTO usuarios (Id, Nombre, Clave, Tipo) VALUES (:id, :nombre, :clave, :tipo)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id' => $id,
        'nombre' => $nombre,
        'clave' => $clave,
        'tipo' => $tipo
    ]);
    echo json_encode(['mensaje' => 'Usuario insertado correctamente']);
}
?>