<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos
if (!isset($data['Id'], $data['NombreComercial'], $data['Telefono'], $data['CreditoMaximo'], $data['Direccion'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

// $id = $data['Id'];
// $nombreComercial = $data['NombreComercial'];
// $telefono = $data['Telefono'];
// $creditoMaximo = $data['CreditoMaximo'];
// $direccion = $data['Direccion'];

$id = $data['Id'];
$nombreComercial = trim($data['NombreComercial']);
$telefono = trim($data['Telefono']);
$creditoMaximo = $data['CreditoMaximo'];
$direccion = trim($data['Direccion']);

// Comprobar si existe el registro por el Id
$sql = "SELECT * FROM proveedores WHERE Id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id' => $id]);

$proveedor = $stmt->fetch(PDO::FETCH_ASSOC);

if ($proveedor) {
    // Si el usuario existe, actualizamos los datos
    $sql = "UPDATE proveedores SET NombreComercial = :nombreComercial, Telefono = :telefono, CreditoMaximo = :creditoMaximo, Direccion = :direccion WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'nombreComercial' => $nombreComercial,
        'telefono' => $telefono,
        'creditoMaximo' => $creditoMaximo,
        'direccion' => $direccion,
        'id' => $id
    ]);
    echo json_encode(['mensaje' => 'Proveedor actualizado correctamente']);
} else {
    // Si el usuario no existe, lo insertamos
    $sql = "INSERT INTO proveedores (Id, NombreComercial, Telefono, CreditoMaximo, Direccion) VALUES (:id, :nombreComercial, :telefono, :creditoMaximo, :direccion)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id' => $id,
        'nombreComercial' => $nombreComercial,
        'telefono' => $telefono,
        'creditoMaximo' => $creditoMaximo,
        'direccion' => $direccion,
    ]);
    echo json_encode(['mensaje' => 'Proveedor insertado correctamente']);
}
?>