<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos
if (!isset($data['Id'], $data['Detalle'], $data['Costo'], $data['Tarifa'], $data['Precio1'], $data['Precio2'], $data['Precio3'], $data['Existencia'], $data['Descuento'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

// Asignar los datos del JSON a variables
$id = $data['Id'];
$detalle = $data['Detalle'];
$costo = $data['Costo'];
$tarifa = $data['Tarifa'];
$precio1 = $data['Precio1'];
$precio2 = $data['Precio2'];
$precio3 = $data['Precio3'];
$existencia = $data['Existencia'];
$descuento = $data['Descuento'];

try {
    // Comprobar si existe el registro por el Id
    $sql = "SELECT * FROM productos WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['id' => $id]);

    $producto = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($producto) {
        // Si el producto existe, actualizamos los datos
        $sql = "UPDATE productos SET Detalle = :detalle, Costo = :costo, Tarifa = :tarifa, Precio1 = :precio1, Precio2 = :precio2, Precio3 = :precio3, Existencia = :existencia, Descuento = :descuento WHERE Id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'detalle' => $detalle,
            'costo' => $costo,
            'tarifa' => $tarifa,
            'precio1' => $precio1,
            'precio2' => $precio2,
            'precio3' => $precio3,
            'existencia' => $existencia,
            'descuento' => $descuento,
            'id' => $id
        ]);
        echo json_encode(['mensaje' => 'Producto actualizado correctamente']);
    } else {
        // Si el producto no existe, lo insertamos
        $sql = "INSERT INTO productos (Id, Detalle, Costo, Tarifa, Precio1, Precio2, Precio3, Existencia, Descuento) VALUES (:id, :detalle, :costo, :tarifa, :precio1, :precio2, :precio3, :existencia, :descuento)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'id' => $id,
            'detalle' => $detalle,
            'costo' => $costo,
            'tarifa' => $tarifa,
            'precio1' => $precio1,
            'precio2' => $precio2,
            'precio3' => $precio3,
            'existencia' => $existencia,
            'descuento' => $descuento
        ]);
        echo json_encode(['mensaje' => 'Producto insertado correctamente']);
    }
} catch (PDOException $e) {
    // Manejo de errores en la base de datos
    echo json_encode(['error' => 'Error en la base de datos: ' . $e->getMessage()]);
}
?>