<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos (solo se requiere 'Id' y 'Sit')
if (!isset($data['Id'], $data['Sit'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

// Asignar los valores recibidos al arreglo
$id = $data['Id'];
$sit = $data['Sit'];

// Comprobar si existe el registro por el Id
$sql = "SELECT * FROM estimado WHERE Id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id' => $id]);

$estimado = $stmt->fetch(PDO::FETCH_ASSOC);

if ($estimado) {
    // Si el registro existe, actualizamos solo el campo 'Sit'
    $sql = "UPDATE estimado SET Sit = :sit WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'sit' => $sit,
        'id' => $id
    ]);
    echo json_encode(['mensaje' => 'Estimado actualizado correctamente']);
} else {
    echo json_encode(['error' => 'Registro no encontrado']);
}
