<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos
if (!isset($data['Id'], $data['NombreComercial'], $data['Cedula'], $data['Direccion'], $data['Telefono'], $data['CorreoElectronico'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

// Asignar los datos
$id = $data['Id'];
$nombreComercial = $data['NombreComercial'];
$cedula = $data['Cedula'];
$direccion = $data['Direccion'];
$telefono = $data['Telefono'];
$correoElectronico = $data['CorreoElectronico'];

try {
    // Comprobar si existe el registro por el Id
    $sql = "SELECT * FROM empresa WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['id' => $id]);

    $empresa = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($empresa) {
        // Si el usuario existe, actualizamos los datos
        $sql = "UPDATE empresa SET NombreComercial = :nombreComercial, Cedula = :cedula, Direccion = :direccion, Telefono = :telefono, CorreoElectronico = :correoElectronico WHERE Id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'nombreComercial' => $nombreComercial,
            'cedula' => $cedula,
            'direccion' => $direccion,
            'telefono' => $telefono,
            'correoElectronico' => $correoElectronico,
            'id' => $id
        ]);
        echo json_encode(['mensaje' => 'Empresa actualizada correctamente']);
    } else {
        // Si el usuario no existe, lo insertamos
        $sql = "INSERT INTO empresa (Id, NombreComercial, Cedula, Direccion, Telefono, CorreoElectronico) VALUES (:id, :nombreComercial, :cedula, :direccion, :telefono, :correoElectronico)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            'id' => $id,
            'nombreComercial' => $nombreComercial,
            'cedula' => $cedula,
            'direccion' => $direccion,
            'telefono' => $telefono,
            'correoElectronico' => $correoElectronico
        ]);
        echo json_encode(['mensaje' => 'Empresa insertada correctamente']);
    }
} catch (PDOException $e) {
    // Manejo de errores en la base de datos
    echo json_encode(['error' => 'Error en la base de datos: ' . $e->getMessage()]);
}
?>