<?php
header('Content-Type: application/json');
include 'db.php'; // Incluir la conexión a la base de datos

// Obtener los datos JSON que se envían en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

// Verificar si los datos están completos
if (!isset($data['Id'], $data['NombreComercial'], $data['Telefono'], $data['Precio'], $data['CreditoMaximo'], $data['Direccion'])) {
    echo json_encode(['error' => 'Faltan datos']);
    exit();
}

$id = $data['Id'];
$nombreComercial = trim($data['NombreComercial']);
$telefono = trim($data['Telefono']);
$precio = trim($data['Precio']);
$creditoMaximo = $data['CreditoMaximo'];
$direccion = trim($data['Direccion']);

// Comprobar si existe el registro por el Id
$sql = "SELECT * FROM clientes WHERE Id = :id";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id' => $id]);

$cliente = $stmt->fetch(PDO::FETCH_ASSOC);

if ($cliente) {
    // Si el usuario existe, actualizamos los datos
    $sql = "UPDATE clientes SET NombreComercial = :nombreComercial, Telefono = :telefono, Precio = :precio, CreditoMaximo = :creditoMaximo, Direccion = :direccion WHERE Id = :id";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'nombreComercial' => $nombreComercial,
        'telefono' => $telefono,
        'precio' => $precio,
        'creditoMaximo' => $creditoMaximo,
        'direccion' => $direccion,
        'id' => $id
    ]);
    echo json_encode(['mensaje' => 'cliente actualizado correctamente']);
} else {
    // Si el usuario no existe, lo insertamos
    $sql = "INSERT INTO clientes (Id, NombreComercial, Telefono, Precio, CreditoMaximo, Direccion) VALUES (:id, :nombreComercial, :telefono, :precio, :creditoMaximo, :direccion)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        'id' => $id,
        'nombreComercial' => $nombreComercial,
        'telefono' => $telefono,
        'precio' => $precio,
        'creditoMaximo' => $creditoMaximo,
        'direccion' => $direccion,
    ]);
    echo json_encode(['mensaje' => 'cliente insertado correctamente']);
}
?>