<?php 
// Iniciar sesión
session_start();
include 'db.php';

// Obtener el valor de búsqueda (si lo hay)
$search = isset($_GET['search']) ? $_GET['search'] : '';

// Consulta SQL para listar productos
$query = "SELECT Id, Detalle, Precio1 FROM productos WHERE Detalle LIKE :search LIMIT 500";
$stmt = $pdo->prepare($query);
$stmt->execute(['search' => "%$search%"]);
$productos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Si se selecciona un producto, almacenar en la sesión
if (isset($_GET['select_producto_id'])) {
    $producto_id = $_GET['select_producto_id'];
    
    // Consultar el detalle del producto seleccionado
    $stmt = $pdo->prepare("SELECT  Id, Detalle, Precio1, Tarifa, Precio1 * (1 + Tarifa / 100) AS PrecioTotal  FROM productos WHERE Id = :id");
    $stmt->execute(['id' => $producto_id]);
    $producto = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($producto) {
        // Guardar datos en sesión
        $_SESSION['producto_id'] = $producto_id;
        $_SESSION['producto_detalle'] = $producto['Detalle'];
        $_SESSION['producto_precio'] = $producto['PrecioTotal'];   
        // Redirigir al formulario de estimado
        header("Location: estimado.php");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Productos</title>
   

    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Estilos personalizados -->
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
        }
        .container {
            max-width: 1200px;
        }
        h2 {
            color: #343a40;
            font-weight: bold;
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }
        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2>Lista de Productos</h2>
        <!-- Botón para regresar a la página principal -->
        <a href="estimado.php" class="btn btn-secondary mb-4">Regresar a la Página Principal</a>
        <!-- Filtro de búsqueda -->
        <form method="GET" class="mb-4">
            <div class="input-group">
                <input type="text" name="search" class="form-control" placeholder="Buscar por nombre" value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit" class="btn btn-primary">Buscar</button>
            </div>
        </form>

        <!-- Tabla de productos -->
        <table class="table table-striped table-bordered table-hover">
            <thead class="table-light">
                <tr>
                    <th>ID</th>
                    <th>Detalle</th>
                    <th>Precio</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($productos as $producto): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($producto['Id']); ?></td>
                        <td><?php echo htmlspecialchars($producto['Detalle']); ?></td>
                        <td>$ <?php echo number_format($producto['Precio1'], 2); ?></td>
                        <td>
                            <a href="?select_producto_id=<?php echo $producto['Id']; ?>" class="btn btn-primary btn-sm">Seleccionar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <!-- Scripts de Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>