<?php
session_start();
// Verifica si el usuario ha iniciado sesión
// Incluir validaciones adicionales si es necesario

if ( $_SESSION['usuario_id'] == "") {
   header("Location: index.php");
   exit;
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listar Facturas por Rango de Fechas</title>
    <!-- Agregar Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            padding-top: 30px;
        }
        .container {
            max-width: 1200px;
        }
        h2 {
            color: #007bff;
            margin-bottom: 30px;
        }
        .table th, .table td {
        
            vertical-align: middle;
        }
        .table th {
            background-color: #007bff;
            color: white;
        }
        .table-bordered {
            border: 2px solid #007bff;
        }
        .btn-custom {
            background-color: #28a745;
            color: white;
        }
        .btn-custom:hover {
            background-color: #218838;
        }
        .alert-custom {
            background-color: #ffdddd;
            color: #f44336;
            padding: 15px;
            margin-top: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Filtrar Facturas por Rango de Fechas</h2>

    <!-- Formulario para filtrar las facturas por fecha -->
    <form action="listar_estimados.php" method="get">
        <div class="row">
            <div class="col-md-4">
                <label for="start_date" class="form-label">Fecha de inicio</label>
                <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" required>
            </div>
            <div class="col-md-4">
                <label for="end_date" class="form-label">Fecha de final</label>
                <input type="date" class="form-control" id="fecha_fin" name="fecha_fin" required>
            </div>
            <div class="col-md-4">
                <button type="submit" class="btn btn-primary mt-4">Filtrar</button>
            </div>
        </div>
    </form>

    <!-- Mostrar resultados aquí -->
    <?php
    include('db.php');

    if (isset($_GET['fecha_inicio']) && isset($_GET['fecha_fin'])) {
        $fecha_inicio = $_GET['fecha_inicio'];
        $fecha_fin = $_GET['fecha_fin'];

        try {
            $query = "SELECT estimado.Id, clientes.NombreComercial, estimado.Total, estimado.Fecha 
                      FROM clientes 
                      INNER JOIN estimado ON clientes.Id = estimado.IdCliente 
                      WHERE Fecha BETWEEN :fecha_inicio AND :fecha_fin 
                      ORDER BY Fecha ASC";
            
            $stmt = $pdo->prepare($query);
            $stmt->bindParam(':fecha_inicio', $fecha_inicio, PDO::PARAM_STR);
            $stmt->bindParam(':fecha_fin', $fecha_fin, PDO::PARAM_STR);
            $stmt->execute();

            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if ($results) {
                echo '<div class="table-responsive mt-4">';
                echo '<table class="table table-bordered">';
                echo '<thead><tr><th>Pedido ID</th><th>Fecha</th><th>Cliente</th><th>Total</th><th>Acciones</th></tr></thead>';
                echo '<tbody>';

                foreach ($results as $row) {
                    $fecha = new DateTime($row['Fecha']);
                    echo '<tr>';
                    echo '<td>' . $row['Id'] . '</td>';
                    echo '<td>' . $fecha->format('d-m-Y') . '</td>';
                    echo '<td>' . $row['NombreComercial'] . '</td>';
                    // echo '<td style="text-align: right">' . number_format($row['Total'], 2, ',', '.') . '</td>';
                    echo '<td style="text-align: right">' . number_format($row['Total'], 2, '.', ',') . '</td>';
                    echo '<td><a href="imprimir_estimado.php?idEstimado=' . $row['Id'] . '" class="btn btn-custom">Ver Pedido</a></td>';
                    echo '</tr>';
                }

                echo '</tbody>';
                echo '</table>';
                echo '</div>';
            } else {
                echo '<div class="alert alert-custom">No se encontraron resultados para el rango de fechas seleccionado.</div>';
            }

        } catch (PDOException $e) {
            echo "Error: " . $e->getMessage();
        }
    }
    ?>

<a href="index.php" class="btn btn-secondary mt-4">Volver a la Página Principal</a>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>