<?php
// Incluir la conexión a la base de datos
include_once 'db.php';

// Definir el encabezado para indicar que se devuelve JSON
header('Content-Type: application/json');

// Definir la consulta SQL
$sql = "SELECT estimado.Id, estimado.IdCliente, clientes.NombreComercial AS Nombre, estimado.Fecha, 
               estimado.IdVendedor, vendedores.Nombre AS NombreVendedor, estimado.Total, 
               estimado.IdRuta, estimado.Sit 
        FROM estimado 
        INNER JOIN clientes ON clientes.Id = estimado.IdCliente 
        INNER JOIN vendedores ON vendedores.Id = estimado.IdVendedor 
        WHERE estimado.Sit = 1";

// Ejecutar la consulta SQL
try {
    // Preparar y ejecutar la consulta
    $stmt = $pdo->prepare($sql);
    $stmt->execute();

    // Obtener los resultados como un arreglo asociativo
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convertir el arreglo a JSON
    echo json_encode($resultados, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
} catch (PDOException $e) {
    // En caso de error, devolver un mensaje de error en formato JSON
    echo json_encode([
        'error' => 'Error en la consulta: ' . $e->getMessage()
    ]);
}
?>