<!-- header.php -->
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>App Móvil</title>

  <!-- Bootstrap 5.2 CDN -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-0evHe/X+R7YkIZDRvuzKMRqM+OrBnVFBL6DOitfPri4tjfHxaWutUpFmBp4vmVor" crossorigin="anonymous">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.0-beta1/dist/js/bootstrap.bundle.min.js" integrity="sha384-pprn3073KE6tl6bjs2QrFaJGz5/SUsLqktiwsUTF55Jfv3qYSDhgCecCxMW52nD2" crossorigin="anonymous"></script>

 
  <style>
  /* General body styles */
  body {
    /* background-image: url('Img/document_12792554.jpg'); */
    background-position: center center;
    background-repeat: no-repeat;
    background-size: cover;
    background-attachment: fixed;
    color: #fff;
    font-family: 'Arial', sans-serif;
    margin: 0;
    padding: 0;
  }

  /* Navbar styles */
  .navbar {
    background-color: rgba(0, 0, 0, 0.6); /* Darker background */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2); /* Enhanced shadow for depth */
    border-radius: 5px;
    padding: 10px 20px;
  }

  .navbar-brand {
    color: #fff;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    font-weight: bold;
    font-size: 1.5rem;
    transition: color 0.3s;
  }

  .navbar-brand:hover {
    color: #1abc9c; /* Modern green */
  }

  .nav-link {
    color: #ecf0f1;
    font-weight: 500;
    font-size: 1rem;
    margin-right: 15px;
    transition: color 0.3s;
  }

  .nav-link:hover {
    color: #1abc9c;
  }

  .navbar-toggler-icon {
    background-color: #ecf0f1;
  }

  /* Dropdown menu styles */
  .dropdown-menu {
    background-color: #fff;
    border-radius: 6px;
    padding: 10px 0;
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
  }

  .dropdown-item {
    color: #2c3e50;
    font-size: 1rem;
    padding: 10px 20px;
    transition: background-color 0.2s, color 0.2s;
  }

  .dropdown-item:hover {
    background-color: #f1f1f1;
    color: #1abc9c;
  }

  /* Navbar for mobile */
  @media (max-width: 767px) {
    .navbar {
      background-color: rgba(0, 0, 0, 0.8); /* Darker background on mobile */
    }

    .navbar-toggler-icon {
      background-color: #1abc9c;
    }
  }

  /* Additional content styles */
  .content {
    padding-top: 80px;
    text-align: center;
  }

  /* Subtle hover effect for nav items */
  .nav-item:hover {
    transform: scale(1.05);
    transition: transform 0.2s ease-in-out;
  }
</style>


</head>
<body>
  <div class="container">
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg">
      <div class="container-fluid">
        <a class="navbar-brand" href="index.php">App Móvil</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNavDropdown">
          <ul class="navbar-nav">
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                Estimados
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="estimado.php">Crear Estimado</a></li>
                <li><a class="dropdown-item" href="ListaEstimados.aspx">Lista Estimados</a></li>
                <li><a class="dropdown-item" href="#">Reportes</a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                Cotizaciones
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#">Crear Cotizacion</a></li>
                <li><a class="dropdown-item" href="#">Lista Cotizaciones</a></li>
                <li><a class="dropdown-item" href="#">Reportes</a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                Login
              </a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="login.php">Acesso</a></li>
                <li><a class="dropdown-item" href="logout.php">Cerrar Sección</a></li>
              </ul>
            </li>
          </ul>
        </div>
      </div>
    </nav>
  </div>
<!-- </body>
</html -->