<?php
session_start();
include 'db.php';

if ( $_SESSION['usuario_id'] == "") {
    header("Location: index.php");
    exit;
 }
// Inicializar variables
$totalEstimado = 0;
$cliente_id = $_SESSION['cliente_id'] ?? '';
$cliente_nombre = $_SESSION['cliente_nombre'] ?? '';

// Procesar formulario de guardar estimado
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['guardar_estimado'])) {
        // Validar que los datos sean completos
        if (empty($cliente_nombre) || empty($_SESSION['detalles']) || empty($cliente_id)) {
            echo "Error: Faltan datos necesarios para guardar el estimado.";
        } else {
            // Guardar estimado en la base de datos
            $stmt = $pdo->prepare("INSERT INTO estimado (IdCliente, Fecha, IdVendedor, Total, IdRuta, Sit) VALUES (?, NOW(), ?, ?, ?, 1)");
            $stmt->execute([$_SESSION['cliente_id'], $_SESSION['vendedor_id'], $_SESSION['totalEstimado'], $_SESSION['ruta_id']]);
            $idEstimado = $pdo->lastInsertId();
            $_SESSION['idEstimado'] = $idEstimado;

            // Guardar detalles
            foreach ($_SESSION['detalles'] as $detalle) {
                $stmt = $pdo->prepare("INSERT INTO estimadodetalle (IdEstimado, IdProducto, Cantidad, Importe) VALUES (?, ?, ?, ?)");
                $stmt->execute([$idEstimado, $detalle['IdProducto'], $detalle['Cantidad'], $detalle['Importe']]);
            }

            // Limpiar sesión después de guardar
            unset($_SESSION['detalles'], $_SESSION['cliente_id'], $_SESSION['cliente_nombre'], $_SESSION['totalEstimado']);       
            $cliente_nombre = '';
            $cliente_id = '';
            echo "Estimado guardado exitosamente.";
        }
    }

    // Borrar detalle
    if (isset($_POST['borrar_detalle'])) {
        $detalleIndex = $_POST['detalle_index'];
        unset($_SESSION['detalles'][$detalleIndex]);
        $_SESSION['detalles'] = array_values($_SESSION['detalles']);
    }

    // Agregar detalle
    if (isset($_POST['agregar_detalle'])) {
        $productoId = $_POST['producto_id'];
        $detalle = $_POST['producto_detalle'];
        $cantidad = $_POST['cantidad'];
        $importe = $cantidad * $_POST['producto_precio'];

        $_SESSION['detalles'][] = [
            'IdProducto' => $productoId,
            'Detalle' => $detalle,
            'Cantidad' => $cantidad,
            'Importe' => $importe
        ];


        unset($_SESSION['producto_id'], $_SESSION['producto_detalle'], $_SESSION['producto_precio']); 


        header("Location: " . $_SERVER['PHP_SELF']);
        exit();
    }

    // Limpiar sesión
    if (isset($_POST['limpiar'])) {
        unset($_SESSION['detalles'], $_SESSION['cliente_id'], $_SESSION['cliente_nombre'], $_SESSION['totalEstimado']);
        $cliente_nombre = '';
        $cliente_id = '';
    }
}

// Calcular total estimado
$detalles = $_SESSION['detalles'] ?? [];
foreach ($detalles as $detalle) {
    $totalEstimado += $detalle['Importe'];
}
$_SESSION['totalEstimado'] = $totalEstimado;
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estimado</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">



    <script>
        var clientWindow = null;  // Variable para almacenar la referencia de la ventana de Clientes
        var productWindow = null; // Variable para almacenar la referencia de la ventana de Productos

        function openClientsAndFocus() {
            clientWindow = window.open('clientes.php', '_blank', 'width=600,height=400');
            var interval = setInterval(function() {
                if (clientWindow && clientWindow.closed) {
                    clearInterval(interval);
                    document.getElementById('cantidad').focus();
                }
            }, 500);
        }

        function openProductsAndFocus() {
            productWindow = window.open('productos.php', '_blank', 'width=600,height=400');
            var interval = setInterval(function() {
                if (productWindow && productWindow.closed) {
                    clearInterval(interval);
                    document.getElementById('cantidad').focus();
                }
            }, 500);
        }

        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('cantidad').focus();
        });
    </script>





</head>
<body>

<div class="container mt-5">
    <h3 class="text-center mb-4">Generar Estimado</h3>

    <form method="POST" class="mb-4">
        <!-- Cliente -->
        <div class="mb-3">
            <label for="cliente_nombre" class="form-label">Cliente</label>
            <div class="input-group">
                <input type="text" id="cliente_nombre" name="cliente_nombre" class="form-control" value="<?php echo htmlspecialchars($cliente_nombre); ?>" readonly>
                <input type="hidden" id="cliente_id" name="cliente_id" value="<?php echo htmlspecialchars($cliente_id); ?>">
                <!-- <button type="button" class="btn btn-outline-primary" onclick="window.open('clientes.php', '_blank', 'width=1000,height=600');">Seleccionar Cliente</button> -->                                
                <!-- <button type="button" class="btn btn-outline-primary" onclick="openClientsAndFocus();">Seleccionar Cliente</button> -->                        
                <!-- <a href="listar_clientes.php" class="btn btn-primary">Ver listado de clientes</a> -->
                <a href="listar_clientes.php" class="btn btn-primary"><i class="bi bi-search"> Buscar</i></a>
            </div>
        </div>

        <!-- Producto -->
        <div class="mb-3">
            <label for="producto_detalle" class="form-label">Producto</label>
            <div class="input-group">
                <!-- <input type="text" id="producto_detalle" name="producto_detalle" class="form-control" readonly>
                <input type="hidden" id="producto_id" name="producto_id"> -->
                <!-- <input type="text" id="producto_id" name="producto_id"> -->
                <!-- <button type="button" class="btn btn-outline-success" onclick="window.open('productos.php', '_blank', 'width=1000,height=800');">Seleccionar Producto</button> -->
                <!-- <button type="button" class="btn btn-outline-success" onclick="openProductsAndFocus();">Seleccionar Producto</button> -->
                <!-- <a href="listar_clientes.php" class="btn btn-primary">Ver listado de clientes</a> -->
                <!-- <a href="listar_productos.php" class="btn btn-primary">Ver listado de productos</a> -->


                <input type="text" id="producto_detalle" name="producto_detalle" class="form-control" value="<?php echo htmlspecialchars($_SESSION['producto_detalle'] ?? ''); ?>" readonly>
                <input type="hidden" id="producto_id" name="producto_id" value="<?php echo htmlspecialchars($_SESSION['producto_id'] ?? ''); ?>">
                    <!-- <input type="text" id="producto_precio" name="producto_precio" value="<?php echo htmlspecialchars($_SESSION['producto_precio'] ?? ''); ?>"> -->
                <!-- <a href="listar_productos.php" class="btn btn-primary">Ver listado de productos</a> -->
                <a href="listar_productos.php" class="btn btn-primary"><i class="bi bi-search"> Buscar</i></a>
            </div>
        </div>

        <!-- Cantidad -->
        <div class="mb-3">
            <label for="cantidad" class="form-label">Cantidad</label>
            <div class="input-group">
                <input type="number" id="cantidad" name="cantidad" class="form-control" placeholder="Cantidad" required>
                <!-- <input type="hidden" id="producto_precio" name="producto_precio"> -->
                <input type="hidden" id="producto_precio" name="producto_precio" value="<?php echo htmlspecialchars($_SESSION['producto_precio'] ?? ''); ?>">
                <button type="submit" name="agregar_detalle" class="btn btn-primary w-100">Agregar Detalle</button>
            </div>
        </div>
    </form>

    <!-- Detalles -->
    <h4>Detalles del Estimado</h4>
    <table class="table table-striped table-bordered">
        <thead class="table-light">
            <tr>
                <th>Producto</th>
                <th>Detalle</th>
                <th>Cantidad</th>
                <th>Importe</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($detalles as $index => $detalle): ?>
                <tr>
                    <td><?php echo htmlspecialchars($detalle['IdProducto']); ?></td>
                    <td><?php echo htmlspecialchars($detalle['Detalle']); ?></td>
                    <td class="text-end"><?php echo htmlspecialchars($detalle['Cantidad']); ?></td>
                    <td class="text-end"><?php echo number_format($detalle['Importe'], 2); ?></td>
                    <td>
                        <form method="POST" style="display:inline;">
                            <input type="hidden" name="detalle_index" value="<?php echo $index; ?>">
                            <button type="submit" name="borrar_detalle" class="btn btn-danger btn-sm"><i class="fas fa-trash-alt"></i></button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Total Estimado -->
    <div class="mb-3">
        <label for="total_estimado" class="form-label"><strong>Total Estimado</strong></label>
        <input type="text" id="total_estimado" class="form-control text-end" value="<?php echo number_format($totalEstimado, 2); ?>" readonly>
    </div>

    <!-- Botones -->
    <form method="POST">
        <button type="submit" name="guardar_estimado" class="btn btn-success w-100 mb-3">Guardar Estimado</button>
        <button type="button" class="btn btn-danger w-100 mb-3" onclick="window.location.href='index.php'">Cancelar</button>
        <a href="imprimir_estimado.php?idEstimado=<?php echo $_SESSION['idEstimado']; ?>" target="_blank" class="btn btn-warning w-100 mb-3">Ver/Imprimir Estimado</a>
    </form>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>

</body>
</html>