<?php
// Incluir archivo de conexión
include 'db.php';

// Obtener el valor del filtro de búsqueda si está presente
$searchTerm = isset($_POST['search']) ? $_POST['search'] : '';

// Preparar la consulta para listar clientes con el filtro aplicado
$sql = "SELECT * FROM clientes WHERE NombreComercial LIKE :searchTerm";
$stmt = $pdo->prepare($sql);
$stmt->execute(['searchTerm' => "%$searchTerm%"]);

// Obtener los resultados
$clientes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listado de Clientes</title>
    <!-- Incluir Bootstrap -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h2>Listado de Clientes</h2>
    
    <!-- Formulario de búsqueda -->
    <form method="POST" class="form-inline mb-3">
        <input type="text" name="search" class="form-control mr-2" placeholder="Buscar por nombre" value="<?= htmlspecialchars($searchTerm) ?>">
        <button type="submit" class="btn btn-primary">Buscar</button>
    </form>

    <!-- Tabla de clientes -->
    <table class="table table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nombre Comercial</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($clientes) > 0): ?>
                <?php foreach ($clientes as $cliente): ?>
                    <tr>
                        <td><?= $cliente['Id'] ?></td>
                        <td><?= htmlspecialchars($cliente['NombreComercial']) ?></td>
                        <td>
                            <!-- Botón para seleccionar el cliente -->
                            <form method="POST" action="seleccionar_cliente.php" style="display:inline;">
                                <input type="hidden" name="cliente_id" value="<?= $cliente['Id'] ?>">
                                <button type="submit" class="btn btn-success">Seleccionar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="3">No se encontraron clientes.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Incluir Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>