<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $vendedor) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $vendedor['Id'];
    $nombre = $vendedor['Nombre'];

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM vendedores WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE vendedores SET
            Nombre = ? WHERE Id = ?");
        $stmt->execute([$nombre, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO vendedores (Nombre)
            VALUES (?)");
        $stmt->execute([$nombre,]);
    }
}

echo json_encode(["status" => "success"]);
?>