<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $usuario) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $usuario['Id'];
    $nombre = $usuario['Nombre'];
    $clave = $usuario['Clave'];
    $tipo = $usuario['Tipo'];

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE usuarios SET
            Nombre = ?, Clave = ?, Tipo = ?
            WHERE Id = ?");
        $stmt->execute([$nombre, $clave, $tipo, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO usuarios (Nombre, Clave, Tipo)
            VALUES (?, ?, ?)");
        $stmt->execute([$nombre, $clave, $tipo]);
    }
}

echo json_encode(["status" => "success"]);
?>