<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $ruta) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $ruta['Id'];
    $nombre = $ruta['Nombre'];

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM rutas WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE rutas SET
            Nombre = ? WHERE Id = ?");
        $stmt->execute([$nombre, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO rutas (Nombre)
            VALUES (?)");
        $stmt->execute([$nombre,]);
    }
}

echo json_encode(["status" => "success"]);
?>