<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $proveedor) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $proveedor['Id'];
    $nombreComercial = $proveedor['NombreComercial'];
    $telefono = $proveedor['Telefono'];
    $creditoMaximo = $proveedor['CreditoMaximo'];
    $direccion = $proveedor['Direccion'];
 

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM proveedores WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE proveedores SET
            NombreComercial = ?, Telefono = ?, CreditoMaximo = ?, Direccion = ?
            WHERE Id = ?");
        $stmt->execute([$nombreComercial, $telefono, $creditoMaximo, $direccion, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO proveedores (NombreComercial, Telefono, CreditoMaximo, Direccion)
            VALUES (?, ?, ?, ?)");
        $stmt->execute([$nombreComercial, $telefono, $creditoMaximo, $direccion]);
    }
}

echo json_encode(["status" => "success"]);
?>