<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $producto) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $producto['Id'];
    $detalle = $producto['Detalle'];
    $costo = $producto['Costo'];
    $tarifa = $producto['Tarifa'];
    $precio1 = $producto['Precio1'];
    $precio2 = $producto['Precio2'];
    $precio3 = $producto['Precio3'];
    $existencia = $producto['Existencia'];
    $descuento = $producto['Descuento'];

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM productos WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE productos SET
            Detalle = ?, Costo = ?, Tarifa = ?, Precio1 = ?, Precio2 = ?, Precio3 = ?, Existencia = ?, Descuento = ?
            WHERE Id = ?");
        $stmt->execute([$detalle, $costo, $tarifa, $precio1, $precio2, $precio3, $existencia, $descuento, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO productos (Id, Detalle, Costo, Tarifa, Precio1, Precio2, Precio3, Existencia, Descuento)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$id, $detalle, $costo, $tarifa, $precio1, $precio2, $precio3, $existencia, $descuento]);
    }
}

echo json_encode(["status" => "success"]);
?>