<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $empresa) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $empresa['Id'];
    $nombreComercial = $empresa['NombreComercial'];
    $cedula = $empresa['Cedula'];
    $direccion = $empresa['Direccion'];
    $telefono = $empresa['Telefono'];
    $correoElectronico = $empresa['CorreoElectronico'];
 

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM empresa WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE empresa SET
            NombreComercial = ?, Cedula = ?, Direccion = ?, Telefono = ?, CorreoElectronico = ?
            WHERE Id = ?");
        $stmt->execute([$nombreComercial, $cedula, $direccion, $telefono, $correoElectronico, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO empresa (Id, NombreComercial, Cedula, Direccion, Telefono, CorreoElectronico)
            VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$id, $nombreComercial, $cedula, $direccion, $telefono, $correoElectronico]);
    }
}

echo json_encode(["status" => "success"]);
?>