<?php
include 'db.php';

// Obtén el JSON enviado en el cuerpo de la solicitud
$json = file_get_contents('php://input');

// Decodifica el JSON a un array asociativo
$data = json_decode($json, true);

// Recorre el array de productos
foreach ($data as $cliente) {
    // Escapar valores para evitar inyección SQL (si es necesario)
    $id = $cliente['Id'];
    $nombreComercial = $cliente['NombreComercial'];
    $telefono = $cliente['Telefono'];
    $precio = $cliente['Precio'];
    $creditoMaximo = $cliente['CreditoMaximo'];
    $direccion = $cliente['Direccion'];
 

    // Verificar si el producto ya existe en la base de datos
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM clientes WHERE Id = ?");
    $stmt->execute([$id]);
    $existe = $stmt->fetchColumn();

    if ($existe > 0) {
        // Actualizar producto si ya existe
        $stmt = $pdo->prepare("UPDATE clientes SET
            NombreComercial = ?, Telefono = ?, Precio = ?, CreditoMaximo = ?, Direccion = ?
            WHERE Id = ?");
        $stmt->execute([$nombreComercial, $telefono, $precio, $creditoMaximo, $direccion, $id]);
    } else {
        // Insertar producto si no existe
        $stmt = $pdo->prepare("INSERT INTO clientes (NombreComercial, Telefono, Precio, CreditoMaximo, Direccion)
            VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$nombreComercial, $telefono, $precio, $creditoMaximo, $direccion]);
    }
}

echo json_encode(["status" => "success"]);
?>