<?php
// Iniciar la sesión
session_start();
// Incluir el archivo de conexión
include('conexion.php');

// Realizar la consulta para obtener los meseros
$sql = "SELECT * FROM meseros"; // Seleccionamos todos los meseros
$result = $conn->query($sql);

// Inicializar el array para los meseros
$meseros = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $meseros[] = $row;
    }
} else {
    $meseros = []; // Si no hay meseros, el array estará vacío
}

// Cerrar la conexión a la base de datos
$conn->close();

// Verificar si se seleccionó un mesero
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mesero_seleccionado = $_POST['mesero'];
    
    // Guardar el ID del mesero en la sesión
    $_SESSION['mesero_id'] = $mesero_seleccionado;
    
    // Redirigir a ordenes.php
    header("Location: productos.php");
    exit();  // Asegura que el script no siga ejecutándose después de la redirección
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pos-Restaurant</title>
    <!-- Agregar Bootstrap -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .mesero-button {
            width: 100%;
            height: 180px; /* Ajusta el tamaño del botón */
            background-image: url('imagenes/mesero.jpg'); /* Imagen común para todos los meseros */
            background-size: contain; /* Asegura que la imagen esté contenida dentro del botón */
            background-repeat: no-repeat; /* No repetir la imagen */
            background-position: center; /* Centra la imagen */
            text-align: center;
            color: black; /* Cambia el color de las letras a negro */
            font-size: 16px;
            font-weight: bold; /* Pone el texto en negrita */
            border: none;
            margin: 10px;
            border-radius: 10px;
            display: flex;
            flex-direction: column; /* Alinea los elementos de arriba hacia abajo */
            justify-content: flex-start; /* Alinea el contenido en la parte superior */
            padding: 10px;
            transition: all 0.3s ease;
        }

        .mesero-button:hover {
            opacity: 0.8;
            transform: scale(1.05);
        }

        .container {
            text-align: center;
        }

        /* Estilo adicional para las pantallas más pequeñas */
        @media (max-width: 768px) {
            .mesero-button {
                height: 120px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2>Selecciona un Mesero</h2>

        <!-- Formulario para los meseros -->
        <form action="" method="POST">
            <div class="row justify-content-center">
                <?php foreach ($meseros as $mesero): ?>
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-4">
                        <!-- Botón para cada mesero -->
                        <button type="submit" name="mesero" value="<?= $mesero['Id']; ?>" class="mesero-button">
                            <div><?= $mesero['Nombre']; ?></div> <!-- Nombre del mesero -->
                        </button>
                    </div>
                <?php endforeach; ?>
            </div>
        </form>
    </div>




    <!-- Agregar Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>