<?php
// Incluir el archivo de conexión
include('conexion.php');

// Realizar la consulta para obtener las mesas y su zona
$sql = "SELECT mesas.Id, mesas.Nombre, zonas.Id AS IdZona, zonas.Nombre AS NombreZona 
        FROM mesas
        LEFT JOIN zonas ON mesas.IdZona = zonas.Id"; // Relacionamos mesas con zonas
$result = $conn->query($sql);

// Inicializar el array para las mesas
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $mesas[] = $row;
    }
} else {
    $mesas = []; // Si no hay mesas, el array estará vacío
}

// Cerrar la conexión a la base de datos
$conn->close();

// Verificar si se seleccionó una mesa
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mesa_seleccionada = $_POST['mesa'];
    
    // Buscar la zona correspondiente a la mesa seleccionada y mostrar su ID
    foreach ($mesas as $mesa) {
        if ($mesa['Id'] == $mesa_seleccionada) {
            // Guardar el ID de la mesa y de la zona en las variables de sesión
            session_start();
            $_SESSION['mesa_id'] = $mesa['Id'];
            $_SESSION['zona_id'] = $mesa['IdZona'];
            
            // Redirigir a obtener_meseros.php
            header("Location: obtener_meseros.php");
            exit();  // Asegura que el script no siga ejecutándose después de la redirección
        }
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pos-Restaurant</title>
    <!-- Agregar Bootstrap -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .mesa-button {
            width: 100%;
            height: 180px; /* Ajusta el tamaño del botón */
            background-image: url('imagenes/mesa.jpg'); /* Imagen común para todas las mesas */
            background-size: contain; /* Asegura que la imagen esté contenida dentro del botón */
            background-repeat: no-repeat; /* No repetir la imagen */
            background-position: center; /* Centra la imagen */
            text-align: center;
            color: black; /* Cambia el color de las letras a negro */
            font-size: 16px;
            font-weight: bold; /* Pone el texto en negrita */
            border: none;
            margin: 10px;
            border-radius: 10px;
            display: flex;
            flex-direction: column; /* Alinea los elementos de arriba hacia abajo */
            justify-content: flex-start; /* Alinea el contenido en la parte superior */
            padding: 10px;
            transition: all 0.3s ease; 
        }

        .mesa-button:hover {
            opacity: 0.8;
            transform: scale(1.05);
        }

        .container {
            text-align: center;
        }

        /* Estilo adicional para las pantallas más pequeñas */
        @media (max-width: 768px) {
            .mesa-button {
                height: 120px;
                font-size: 14px;
            }
        }

        /* Estilo para mostrar la zona seleccionada */
        .zona-seleccionada {
            margin-top: 20px;
            font-size: 20px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2>Selecciona una Mesa</h2>

        <!-- Formulario para las mesas -->
        <form action="" method="POST">
            <div class="row justify-content-center">
                <?php foreach ($mesas as $mesa): ?>
                    <div class="col-12 col-sm-6 col-md-4 col-lg-3 col-xl-2 mb-4">
                        <!-- Botón para cada mesa, con la misma imagen -->
                        <button type="submit" name="mesa" value="<?= $mesa['Id']; ?>" class="mesa-button">
                            <div><?= $mesa['Nombre']; ?></div>
                            <!-- <div><?= $mesa['NombreZona']; ?></div> -->
                        </button>
                    </div>
                <?php endforeach; ?>
            </div>
        </form>

    </div>

   
    <!-- Agregar Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>