<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pos-Restaurant</title>
    <style>
        /* Estilos generales */
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
            color: #333;
        }
        h1, h2 {
            margin: 0;
        }
        
        /* Estilos del contenedor principal */
        .hero {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-image: url('https://via.placeholder.com/1500x800'); /* Cambia por una imagen de alta calidad */
            background-size: cover;
            background-position: center;
            text-align: center;
            color: white;
            padding: 0 20px;
        }
        
        /* Título */
        .hero h1 {
            font-size: 3rem;
            text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.5);
        }

        /* Subtítulo */
        .hero h2 {
            font-size: 1.5rem;
            margin-top: 10px;
            font-weight: 300;
            text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);
        }

        /* Estilos de los botones */
        .buttons {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            gap: 15px;
        }

        .button {
            background-color: #ff6600;
            color: white;
            padding: 15px 30px;
            font-size: 1.2rem;
            font-weight: 600;
            border: none;
            border-radius: 30px;
            cursor: pointer;
            text-transform: uppercase;
            transition: all 0.3s ease;
        }

        .button:hover {
            background-color: #e65c00;
            transform: scale(1.05);
        }

        .button:focus {
            outline: none;
        }

        /* Estilos para pantallas pequeñas (responsive) */
        @media (max-width: 768px) {
            .hero {
                background-position: top;
            }
            .hero h1 {
                font-size: 2.5rem;
            }
            .hero h2 {
                font-size: 1.2rem;
            }
            .buttons {
                flex-direction: column;
                gap: 10px;
            }
        }
    </style>
</head>
<body>

    <div class="hero">
        <h1>Restaurante Gourmet</h1>
        <h2>Descubre una experiencia culinaria única</h2>
        <div class="buttons">
            <button class="button" onclick="window.location.href='obtener_mesas.php'">Mesas</button>
            <button class="button" onclick="window.close();">Salir</button>
        </div>
    </div>

</body>
</html>