<?php
session_start();
include 'conexion.php';

// Verificar si las variables necesarias existen en la sesión
if (!isset($_SESSION['mesa_id']) || !isset($_SESSION['zona_id']) || !isset($_SESSION['mesero_id'])) {
    die("Faltan datos en la sesión.");
}

// Recuperar las variables de la sesión
$mesa_id = $_SESSION['mesa_id'];
$zona_id = $_SESSION['zona_id'];
$mesero_id = $_SESSION['mesero_id'];
//$Estado = isset($Estado) ? $Estado : 0;  // Si no está definida, por defecto se asume 0
//$Total = isset($Total) ? $Total : 0;
$Nota = isset($Nota) ? $Nota : '';

// Verificar si existe un registro en la tabla temp con estado 0 o 1
$query = "SELECT Id, Estado, Total FROM temp WHERE IdMesa = ? AND Estado IN (0, 1) ORDER BY Fecha DESC LIMIT 1";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $mesa_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    // Si existe un registro, actualizarlo
    $row = $result->fetch_assoc();
    $comanda_id = $row['Id'];
    $estado_actual = $row['Estado'];
    $total_anterior = $row['Total'];

    foreach ($_SESSION['comanda'] as $id_producto => $detalle) {
        $Total = $detalle['TotalLinea'];
    }
    
    // Si el estado es 1, actualizar el total de la comanda con el nuevo total
    if ($estado_actual == 1) {
        $nuevo_total = $total_anterior + $Total;  // Acumulamos el nuevo total
        $update_query = "UPDATE temp SET Total = ?, Nota = ? WHERE Id = ?";
        $update_stmt = $conn->prepare($update_query);
        $update_stmt->bind_param("dsi", $nuevo_total, $Nota, $comanda_id);
        $update_stmt->execute();
    }
} else {
    foreach ($_SESSION['comanda'] as $id_producto => $detalle) {
        $Total = $detalle['TotalLinea'];
    }
    $Estado = 1 ;
    // Si no existe un registro, insertar una nueva comanda
    $fecha = date('Y-m-d H:i:s');
    $insert_query = "INSERT INTO temp (Fecha, IdMesa, IdZona, IdMesero, Estado, Total, Nota) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $insert_stmt = $conn->prepare($insert_query);
    $insert_stmt->bind_param("siidiss", $fecha, $mesa_id, $zona_id, $mesero_id, $Estado, $Total, $Nota);
    $insert_stmt->execute();
    $comanda_id = $insert_stmt->insert_id;


     //Editar estado de mesa
    $EstadoMesa = 1;
    $update_query = "UPDATE mesas SET  Estado = ? WHERE Id = ?";
    $update_stmt = $conn->prepare($update_query);
    $update_stmt->bind_param("si", $EstadoMesa, $mesa_id);
    $update_stmt->execute();
}

// Insertar los detalles de la comanda
foreach ($_SESSION['comanda'] as $id_producto => $detalle) {
    $detalle_producto = $detalle['Detalle'];
    $cantidad = $detalle['cantidad'];
    $precio = $detalle['precio'];
    $impuesto = $detalle['Impuesto'];
    $descuento = $detalle['Descuento'];
    $monto_descuento = $detalle['MontoDescuento'];
    $total_linea = $detalle['TotalLinea'];

    $insert_detalle_query = "INSERT INTO tempdetalle (IdTemp, IdProducto, Detalle, Cantidad, Precio, Impuesto, Descuento, MontoDescuento, TotalLinea) 
                             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $insert_detalle_stmt = $conn->prepare($insert_detalle_query);
    //$insert_detalle_stmt->bind_param("issddddd", $comanda_id, $id_producto, $detalle_producto, $cantidad, $precio, $impuesto, $descuento, $monto_descuento, $total_linea);
    $insert_detalle_stmt->bind_param("issdddddd", $comanda_id, $id_producto, $detalle_producto, $cantidad, $precio, $impuesto, $descuento, $monto_descuento, $total_linea);
    $insert_detalle_stmt->execute();
}

// Confirmar éxito
//echo "Comanda guardada con éxito.";

unset($_SESSION['comanda']);
header('Location: mensaje_comanda_guardada.php');
?>