<?php
session_start();

// Verificar si hay productos en la comanda
 if (!isset($_SESSION['comanda']) || empty($_SESSION['comanda'])) {
     header('Location: mensaje_comanda_vacia.php');
     exit();
 }




// Procesar el formulario si se está actualizando la cantidad o eliminando productos
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Actualizar cantidades de productos
    if (isset($_POST['actualizar'])) {
        foreach ($_POST['cantidad'] as $id_producto => $cantidad) {
            $cantidad = (int)$cantidad;
            if ($cantidad > 0) {
                $_SESSION['comanda'][$id_producto]['cantidad'] = $cantidad;
                $_SESSION['comanda'][$id_producto]['TotalLinea'] = $_SESSION['comanda'][$id_producto]['precio'] * $cantidad;
            } else {
                unset($_SESSION['comanda'][$id_producto]); // Eliminar el producto si la cantidad es 0 o menos
            }
        }
    }

    // Eliminar un producto específico
    if (isset($_POST['eliminar'])) {
        $id_producto_eliminar = $_POST['eliminar'];
        unset($_SESSION['comanda'][$id_producto_eliminar]); // Eliminar el producto de la comanda
    }

    // Cancelar la comanda
    if (isset($_POST['cancelar'])) {
        unset($_SESSION['comanda']);  // Eliminar toda la comanda de la sesión
        header('Location: productos.php');  // Redirigir a productos.php
        exit();
    }
}

// Calcular los totales
$total_comanda = 0;
foreach ($_SESSION['comanda'] as $producto) {
    $total_comanda += $producto['TotalLinea'];
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pos-Restaurant</title>
    <link href="https://fonts.googleapis.com/css2?family=Lora:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Lora', serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            color: #555;
        }

        header {
            background-color: #333;
            color: white;
            text-align: center;
            padding: 30px 0;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        h2 {
            font-size: 28px;
            margin: 0;
            font-weight: 700;
        }

        table {
            width: 90%;
            margin: 30px auto;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        th, td {
            padding: 15px 20px;
            text-align: center;
            border-bottom: 1px solid #eee;
        }

        th {
            background-color: #fafafa;
            font-weight: 700;
        }

        td input[type="number"] {
            width: 70px;
            padding: 8px;
            font-size: 14px;
            border-radius: 5px;
            border: 1px solid #ddd;
            text-align: center;
            transition: all 0.3s ease;
        }

        td input[type="number"]:focus {
            outline: none;
            border-color: #4CAF50;
        }

        .button {
            background-color: #4CAF50;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            display: inline-block;
            transition: background-color 0.3s ease;
            text-align: center;
        }

        .button:hover {
            background-color: #45a049;
        }

        .button-danger {
            background-color: #f44336;
        }

        .button-danger:hover {
            background-color: #e53935;
        }

        /* Nueva clase para el botón "Actualizar Comanda" */
        .button-update {
            background-color: #FF9800; /* Naranja */
            color: white;
            padding: 14px 28px;
            font-size: 18px;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            cursor: pointer;
            display: inline-block;
            transition: all 0.3s ease;
            text-align: center;
            border: 2px solid #FF9800; /* Borde que resalta */
        }

        .button-update:hover {
            background-color: #FB8C00; /* Oscurece el color al pasar el ratón */
            border-color: #FB8C00; /* Asegura que el borde también cambie */
        }

        .button-update:focus {
            outline: none; /* Elimina el borde al hacer clic */
        }

        /* Clases personalizadas para los botones */
        .button-return {
            background-color: #2196F3; /* Azul */
        }

        .button-return:hover {
            background-color: #1976D2; /* Azul oscuro */
        }

        .button-save {
            background-color: #4CAF50; /* Verde */
        }

        .button-save:hover {
            background-color: #45a049; /* Verde oscuro */
        }

        .buttons-container {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            flex-wrap: wrap;
        }

        .buttons-container a {
            margin: 10px;
            flex: 1 1 45%;
            text-align: center;
        }

        .total-container {
            text-align: right;
            margin-top: 20px;
            padding-right: 10%;
        }

        .total-container h3 {
            font-size: 22px;
            font-weight: 700;
            margin: 10px 0;
        }

        @media (max-width: 768px) {
            table {
                width: 100%;
            }

            th, td {
                font-size: 14px;
            }

            td input[type="number"] {
                width: 50px;  /* Ajusta el tamaño del input en móviles */
            }

            .buttons-container {
                flex-direction: column;
                align-items: center;
            }

            .buttons-container a {
                width: 100%;
            }

            td button {
                font-size: 14px;
                padding: 8px 12px;
                width: 100%;
                box-sizing: border-box;
            }
        }

        @media (max-width: 480px) {
            table {
                font-size: 12px;
            }
        }

    </style>
</head>
<body>

<header>
    <h2>Comanda de Productos</h2>
</header>

<form method="POST">
    <table>
        <thead>
            <tr>
                <th>Detalle</th>
                <th>Cantidad</th>
                <th>Precio</th>
                <th>Total</th>
                <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($_SESSION['comanda'] as $id_producto => $producto): ?>
                <tr>
                    <td><?php echo htmlspecialchars($producto['Detalle']); ?></td>
                    <td><input type="number" name="cantidad[<?php echo $id_producto; ?>]" value="<?php echo $producto['cantidad']; ?>" min="1" /></td>
                    <td><?php echo number_format($producto['precio'], 2); ?> </td>
                    <td><?php echo number_format($producto['TotalLinea'], 2); ?> </td>
                    <td>
                        <button type="submit" name="eliminar" value="<?php echo $id_producto; ?>" class="button button-danger">Eliminar</button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="total-container">
        <h3>Total de la Comanda: <?php echo number_format($total_comanda, 2); ?> </h3>
        <button type="submit" name="actualizar" class="button button-update">Actualizar Comanda</button>
    </div>
</form>

<div class="buttons-container">
    <a href="productos.php" class="button button-return">Regresar a Productos</a>
    <a href="eliminar_comanda.php" class="button button-danger">Eliminar Comanda</a>
    <a href="guardar_comanda.php" class="button button-save">Guardar Comanda</a>
</div>

</body>
</html>