<?php
session_start();
include 'conexion.php'; 

// Verificar si la conexión fue exitosa
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}

// Obtener todas las categorías
$sql = "SELECT * FROM categorias";
$result = $conn->query($sql);
$categorias = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $categorias[] = $row;
    }
} else {
    $categorias = [];
}

// Obtener productos de la categoría seleccionada si hay una categoría filtrada
$productos = [];
$categoria_id = isset($_SESSION['categoria_id']) ? $_SESSION['categoria_id'] : 1;

if (isset($_GET['categoria_id'])) {
    $_SESSION['categoria_id'] = $_GET['categoria_id'];
    $categoria_id = $_SESSION['categoria_id'];
}

// Obtener productos de la categoría seleccionada
$sql = "SELECT * FROM productos WHERE IdCategoria = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $categoria_id);
$stmt->execute();
$result = $stmt->get_result();
$productos = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $productos[] = $row;
    }
}
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pos-Restaurant</title>
    <!-- Vincula Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Vincula Font Awesome (si lo necesitas para iconos) -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h3 class="text-center mb-4">Seleccione una Categoría</h3>
        <form action="categorias.php" method="GET">
            <div class="form-group">
                <label for="categoria">Categorías disponibles:</label>
                <select name="categoria_id" class="form-control" id="categoria">
                    <option value="">-- Elija una categoría --</option>
                    <?php foreach ($categorias as $categoria): ?>
                        <option value="<?= $categoria['Id'] ?>" <?= ($categoria_id == $categoria['Id']) ? 'selected' : '' ?>>
                            <?= htmlspecialchars($categoria['Nombre']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="text-center mt-3">
                <button type="submit" class="btn btn-primary btn-lg">Ver Productos</button>
            </div>
        </form>
    </div>

    <?php if (!empty($productos)): ?>
        <div class="container mt-5">
            <h3 class="text-center mb-4">Lista de Productos</h3>
            <div class="row">
                <?php foreach ($productos as $producto): ?>
                    <div class="col-sm-12 col-md-4 col-lg-3 mb-4">
                        <div class="card shadow-sm">
                            <img src="<?= htmlspecialchars($producto['Foto']) ?>" class="card-img-top" alt="<?= htmlspecialchars($producto['Detalle']) ?>" style="height: 250px; object-fit: cover;">
                            <div class="card-body">
                                <h5 class="card-title"><?= htmlspecialchars($producto['Detalle']) ?></h5>
                                <p class="card-text">¢<?= number_format($producto['Pvp'], 2) ?></p>
                                <div class="d-flex justify-content-between align-items-center">
                                    <a href="agregar_carrito.php?codigo=<?= $producto['Codigo'] ?>&cantidad=1" class="btn btn-primary">Agregar al carrito</a>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <!-- Footer -->
    <footer class="bg-dark text-white text-center py-4 mt-5">
        <p>&copy; 2025 Tu Tienda Online. Todos los derechos reservados.</p>
        <p><a href="privacy-policy.php" class="text-white">Política de Privacidad</a> | <a href="contact.php" class="text-white">Contáctanos</a></p>
    </footer>

    <!-- Vincula el JavaScript de Bootstrap -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
</body>
</html>



