<?php
// Incluir el archivo de conexión
include 'includes/conexion.php';
include 'includes/config.php';
session_start();

// Redireccionar si el usuario no está logueado
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];

// Inicializar o recuperar el array de productos de la sesión
if (!isset($_SESSION['productos_pedido'])) {
    $_SESSION['productos_pedido'] = [];
}
$productos = &$_SESSION['productos_pedido']; // Usar una referencia para trabajar directamente con la sesión

// Variables para los detalles del producto y mensajes
$codigo_producto = $detalle_producto = '';
$cantidad = 0;
$proveedor = ''; // El proveedor se maneja en el formulario de guardar
$error = '';
$success = '';

// Buscar producto por código (GET request)
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['codigo_producto'])) {
    $codigo_producto_busqueda = trim($_GET['codigo_producto']); // Sanitizar y limpiar
    if (!empty($codigo_producto_busqueda)) {
        try {
            $stmt = $pdo->prepare("SELECT * FROM productos WHERE Codigo = :codigo_producto");
            $stmt->bindParam(':codigo_producto', $codigo_producto_busqueda);
            $stmt->execute();
            
            $producto = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($producto) {
                $codigo_producto = $producto['Codigo']; // Asignar el código encontrado
                $detalle_producto = $producto['Detalle'];
            } else {
                $error = "Producto no encontrado.";
            }
        } catch (PDOException $e) {
            $error = "Error al buscar el producto: " . $e->getMessage();
        }
    } else {
        $error = "El código del producto no puede estar vacío.";
    }
}

// Agregar productos al array (POST request para agregar)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'add_product') {
    $codigo_producto_post = trim($_POST['codigo_producto']);
    $cantidad_post = filter_var($_POST['cantidad'], FILTER_VALIDATE_INT, array("options" => array("min_range"=>1))); // Cantidad mínima 1

    if (!empty($codigo_producto_post) && $cantidad_post !== false) {
        try {
            $stmt = $pdo->prepare("SELECT * FROM productos WHERE Codigo = :codigo_producto");
            $stmt->bindParam(':codigo_producto', $codigo_producto_post);
            $stmt->execute();
            
            $producto = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($producto) {
                // Añadir el producto al array de la sesión
                $_SESSION['productos_pedido'][] = [
                    'codigo_producto' => $producto['Codigo'],
                    'detalle_producto' => $producto['Detalle'],
                    'cantidad' => $cantidad_post
                ];
                $success = "Producto '{$producto['Detalle']}' añadido al pedido.";
                // Opcional: Limpiar el campo de código_producto y detalle_producto después de añadir
                $codigo_producto = ''; 
                $detalle_producto = '';
            } else {
                $error = "Producto no encontrado al intentar agregar.";
            }
        } catch (PDOException $e) {
            $error = "Error al agregar el producto: " . $e->getMessage();
        }
    } else {
        $error = "Datos de producto o cantidad inválidos. La cantidad debe ser un número entero mayor o igual a 1.";
    }
}

// Eliminar un producto del array (POST request para eliminar)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'remove_product') {
    $index_to_remove = filter_var($_POST['product_index'], FILTER_VALIDATE_INT);

    // Validar que el índice sea un número y exista en el array de la sesión
    if ($index_to_remove !== false && isset($_SESSION['productos_pedido'][$index_to_remove])) {
        $removed_product_detail = $_SESSION['productos_pedido'][$index_to_remove]['detalle_producto'];
        unset($_SESSION['productos_pedido'][$index_to_remove]);
        // Reindexar el array para evitar huecos en los índices
        $_SESSION['productos_pedido'] = array_values($_SESSION['productos_pedido']); 
        $success = "Producto '{$removed_product_detail}' eliminado del pedido.";
    } else {
        $error = "Error al intentar eliminar el producto. Índice no válido.";
    }
}


// Guardar los datos en archivo (POST request para guardar el pedido completo)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'save_order') {
    $proveedor = trim($_POST['proveedor']);
    // Sanitizar el nombre del proveedor para el nombre del archivo
    $proveedor_sanitized = preg_replace('/[^a-zA-Z0-9_\-]/', '', $proveedor); // Permite letras, números, guiones bajos y guiones

    if (!empty($proveedor_sanitized) && !empty($productos)) {
        // Crear directorio si no existe
        if (!is_dir('archivos')) {
            if (!mkdir('archivos', 0777, true)) {
                $error = "Error: No se pudo crear el directorio 'archivos'. Verifique permisos.";
            }
        }

        if (empty($error)) { // Solo procede si no hubo error al crear el directorio
            $fecha = date("Y-m-d_H-i-s");
            // Usar basename para prevenir inyección de ruta, aunque el regex ya ayuda
            $nombre_archivo = "archivos/" . basename("{$proveedor_sanitized}_{$fecha}.txt"); 

            $archivo = fopen($nombre_archivo, 'w');
            if ($archivo) {
                foreach ($productos as $producto) {
                    $contenido = "Código  : {$producto['codigo_producto']}\n";
                    $contenido .= "Detalle : {$producto['detalle_producto']}\n";
                    $contenido .= "Cantidad: {$producto['cantidad']}\n";
                    $contenido .= "-----------------------------\n";
                    fwrite($archivo, $contenido);
                }
                
                fwrite($archivo, "Proveedor: " . htmlspecialchars($proveedor) . "\n"); // Guardar el nombre original del proveedor en el contenido
                fwrite($archivo, "Fecha y Hora: $fecha\n");
                
                fclose($archivo);

                // Limpiar los productos una vez guardados de la sesión
                $_SESSION['productos_pedido'] = [];
                $productos = &$_SESSION['productos_pedido']; // Restablecer la referencia
                $success = "Pedido guardado correctamente en '{$nombre_archivo}'.";
            } else {
                $error = "Error al guardar el archivo. Verifique permisos de escritura.";
            }
        }
    } else {
        $error = "Debe ingresar el nombre del proveedor y agregar al menos un producto al pedido.";
    }
}


// if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'save_order') {

//     $productos = $_SESSION['productos_pedido'] ?? [];

//     $proveedor = trim($_POST['proveedor']);
//     $proveedor_sanitized = preg_replace('/[^a-zA-Z0-9_\-]/', '', $proveedor);

//     if (!empty($proveedor_sanitized) && !empty($productos)) {
//         $fecha = date("Y-m-d_H-i-s");

//         // Ruta absoluta a la carpeta Descargas del usuario en Windows (ajusta TU_USUARIO)
//         $downloads_path = "C:\Users\Usuario/Downloads";
//         $nombre_archivo = $downloads_path . "/" . basename("{$proveedor_sanitized}_{$fecha}.txt");

//         $archivo = fopen($nombre_archivo, 'w');
//         if ($archivo) {
//             foreach ($productos as $producto) {
//                 $contenido = "Código  : {$producto['codigo_producto']}\n";
//                 $contenido .= "Detalle : {$producto['detalle_producto']}\n";
//                 $contenido .= "Cantidad: {$producto['cantidad']}\n";
//                 $contenido .= "-----------------------------\n";
//                 fwrite($archivo, $contenido);
//             }

//             fwrite($archivo, "Proveedor: " . htmlspecialchars($proveedor) . "\n");
//             fwrite($archivo, "Fecha y Hora: $fecha\n");

//             fclose($archivo);

//             $_SESSION['productos_pedido'] = [];
//             $productos = &$_SESSION['productos_pedido'];

//             $success = "Pedido guardado correctamente en '{$nombre_archivo}'.";
//         } else {
//             $error = "Error al guardar el archivo. Verifique permisos de escritura.";
//         }
//     } else {
//         $error = "Debe ingresar el nombre del proveedor y agregar al menos un producto al pedido.";
//     }
// }

// Depuración: Verificar que los productos estén en el array de sesión
// echo '<pre>'; var_dump($_SESSION['productos_pedido']); echo '</pre>';
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Toma de Pedidos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<div class="container mt-5">
    <h2 class="mb-4">Toma de Pedidos</h2>

    <?php if (!empty($error)) : ?>
        <div class="alert alert-danger mt-3"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <?php if (!empty($success)) : ?>
        <div class="alert alert-success mt-3"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    <!-- <div class="card mb-4">
        <div class="card-body">
            <h4 class="card-title">Buscar Producto</h4>
            <form action="toma_pedidos.php" method="get">
                <div class="mb-3">
                    <label for="codigo_producto_search" class="form-label">Código de Producto</label>
                    <input type="text" class="form-control" id="codigo_producto_search" name="codigo_producto" value="<?= htmlspecialchars($codigo_producto) ?>" required>
                </div>
                <button type="submit" class="btn btn-primary-custom">Buscar</button>
            </form>
        </div>
    </div>  -->

<div class="mi-contenedor">
    <div class="contenido-formulario">
        <h4 class="titulo-formulario">Buscar Producto</h4>
        <form action="toma_pedidos.php" method="get">
            <div class="grupo-formulario">
                <label for="codigo_producto_search">Código de Producto</label>
                <input type="text" id="codigo_producto_search" name="codigo_producto" value="<?= htmlspecialchars($codigo_producto) ?>" required>
            </div>
            <button type="submit" class="boton-buscar">Buscar</button>
        </form>
    </div>
</div>


    <?php if (!empty($codigo_producto) && !empty($detalle_producto)) : ?>
        <!-- <div class="card mb-4">
            <div class="card-body">
                <h4 class="card-title">Producto Encontrado: <?= htmlspecialchars($detalle_producto) ?> (<?= htmlspecialchars($codigo_producto) ?>)</h4>
                <form action="toma_pedidos.php" method="post">
                    <div class="mb-3">
                        <label for="cantidad" class="form-label">Cantidad a Pedir</label>
                        <input type="number" class="form-control" id="cantidad" name="cantidad" value="1" min="1" required>
                    </div>
                    <input type="hidden" name="codigo_producto" value="<?= htmlspecialchars($codigo_producto) ?>">
                    <input type="hidden" name="action" value="add_product">
                    <button type="submit" class="btn btn-success btn-primary-custom">Agregar al Pedido</button>
                </form>
            </div>
        </div> -->

        <div class="producto-contenedor">
    <div class="producto-detalle">
        <h4 class="producto-titulo">
            Producto Encontrado: <?= htmlspecialchars($detalle_producto) ?> (<?= htmlspecialchars($codigo_producto) ?>)
        </h4>
        <form action="toma_pedidos.php" method="post">
            <div class="form-grupo">
                <label for="cantidad" class="form-etiqueta">Cantidad a Pedir</label>
                <input type="number" id="cantidad" name="cantidad" class="form-entrada" value="1" min="1" required>
            </div>
            <input type="hidden" name="codigo_producto" value="<?= htmlspecialchars($codigo_producto) ?>">
            <input type="hidden" name="action" value="add_product">
            <button type="submit" class="boton-agregar">Agregar al Pedido</button>
        </form>
    </div>
</div>

    <?php endif; ?>

    <?php if (!empty($productos)) : ?>
        <!-- <div class="card mb-4">
            <div class="card-body">
                <h4 class="card-title">Productos en el Pedido</h4>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Código</th>
                            <th>Detalle</th>
                            <th>Cantidad</th>
                            <th>Acción</th> </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($productos as $index => $producto_en_pedido) : ?>
                            <tr>
                                <td><?= htmlspecialchars($producto_en_pedido['codigo_producto']) ?></td>
                                <td><?= htmlspecialchars($producto_en_pedido['detalle_producto']) ?></td>
                                <td><?= htmlspecialchars($producto_en_pedido['cantidad']) ?></td>
                                <td>
                                    <form action="toma_pedidos.php" method="post" style="display:inline;">
                                        <input type="hidden" name="action" value="remove_product">
                                        <input type="hidden" name="product_index" value="<?= $index ?>">
                                        <button type="submit" class="btn btn-danger btn-sm">
                                            <i class="bi bi-trash"></i> Eliminar
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div> -->

        <div class="pedido-contenedor">
    <div class="pedido-cuerpo">
        <h4 class="pedido-titulo">Productos en el Pedido</h4>
        <table class="tabla-pedido">
            <thead>
                <tr>
                    <th>Código</th>
                    <th>Detalle</th>
                    <th>Cantidad</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($productos as $index => $producto_en_pedido) : ?>
                    <tr>
                        <td><?= htmlspecialchars($producto_en_pedido['codigo_producto']) ?></td>
                        <td><?= htmlspecialchars($producto_en_pedido['detalle_producto']) ?></td>
                        <td><?= htmlspecialchars($producto_en_pedido['cantidad']) ?></td>
                        <td>
                            <form action="toma_pedidos.php" method="post" style="display:inline;">
                                <input type="hidden" name="action" value="remove_product">
                                <input type="hidden" name="product_index" value="<?= $index ?>">
                                <button type="submit" class="boton-eliminar">
                                    🗑 Eliminar
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
    <?php endif; ?>

    <?php if (!empty($productos)) : ?>
        <!-- <div class="card mb-4">
            <div class="card-body">
                <h4 class="card-title">Finalizar Pedido</h4>
                <form action="toma_pedidos.php" method="post">
                    <div class="mb-3">
                        <label for="proveedor" class="form-label">Nombre del Proveedor</label>
                        <input type="text" class="form-control" id="proveedor" name="proveedor" value="" required>
                    </div>
                    <input type="hidden" name="action" value="save_order">
                    <button type="submit" name="guardar" class="btn btn-primary-custom">Guardar Pedido</button>
                </form>
            </div>
        </div> -->

        <div class="pedido-finalizar-contenedor">
    <div class="pedido-finalizar-cuerpo">
        <h4 class="pedido-finalizar-titulo">Finalizar Pedido</h4>
        <form action="toma_pedidos.php" method="post">
            <div class="form-grupo">
                <label for="proveedor" class="form-etiqueta">Nombre del Proveedor</label>
                <input 
                    type="text" 
                    id="proveedor" 
                    name="proveedor" 
                    class="form-entrada" 
                    value="" 
                    required
                >
            </div>
            <input type="hidden" name="action" value="save_order">
            <button type="submit" name="guardar" class="boton-guardar">Guardar Pedido</button>
        </form>
    </div>
</div>

    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>