<?php
include 'includes/conexion.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];

if (!isset($_SESSION['productos_toma'])) {
    $_SESSION['productos_toma'] = [];
}
$productos = &$_SESSION['productos_toma'];

$codigo_producto = $detalle_producto = '';
$cantidad = 0;
$error = '';
$success = '';

// Buscar producto
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['codigo_producto'])) {
    $codigo_producto_busqueda = trim($_GET['codigo_producto']);
    if (!empty($codigo_producto_busqueda)) {
        try {
            $stmt = $pdo->prepare("SELECT * FROM productos WHERE Codigo = :codigo_producto");
            $stmt->bindParam(':codigo_producto', $codigo_producto_busqueda);
            $stmt->execute();
            $producto = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($producto) {
                $codigo_producto = $producto['Codigo'];
                $detalle_producto = $producto['Detalle'];
            } else {
                $error = "Producto no encontrado.";
            }
        } catch (PDOException $e) {
            $error = "Error al buscar el producto: " . $e->getMessage();
        }
    } else {
        $error = "El código del producto no puede estar vacío.";
    }
}

// Agregar producto
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'add_product') {
    $codigo_producto_post = trim($_POST['codigo_producto']);
    $cantidad_post = filter_var($_POST['cantidad'], FILTER_VALIDATE_INT, ["options" => ["min_range" => 1]]);

    if (!empty($codigo_producto_post) && $cantidad_post !== false) {
        try {
            $stmt = $pdo->prepare("SELECT * FROM productos WHERE Codigo = :codigo_producto");
            $stmt->bindParam(':codigo_producto', $codigo_producto_post);
            $stmt->execute();
            $producto = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($producto) {
                $_SESSION['productos_toma'][] = [
                    'codigo_producto' => $producto['Codigo'],
                    'detalle_producto' => $producto['Detalle'],
                    'cantidad' => $cantidad_post
                ];
                $success = "Producto '{$producto['Detalle']}' añadido.";
                $codigo_producto = ''; 
                $detalle_producto = '';
            } else {
                $error = "Producto no encontrado.";
            }
        } catch (PDOException $e) {
            $error = "Error al agregar: " . $e->getMessage();
        }
    } else {
        $error = "Cantidad inválida.";
    }
}

// Eliminar producto
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'remove_product') {
    $index_to_remove = filter_var($_POST['product_index'], FILTER_VALIDATE_INT);
    if ($index_to_remove !== false && isset($_SESSION['productos_toma'][$index_to_remove])) {
        unset($_SESSION['productos_toma'][$index_to_remove]);
        $_SESSION['productos_toma'] = array_values($_SESSION['productos_toma']);
        $success = "Producto eliminado.";
    } else {
        $error = "Índice inválido.";
    }
}

// Guardar toma física
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'save_order') {
    if (!empty($productos)) {
        if (!is_dir('toma_fisica')) {
            if (!mkdir('toma_fisica', 0777, true)) {
                $error = "No se pudo crear el directorio 'archivos'.";
            }
        }

        if (empty($error)) {
            $fecha = date("Y-m-d_H-i-s");
            $nombre_archivo = "toma_fisica/toma_fisica_{$fecha}.txt";
            $archivo = fopen($nombre_archivo, 'w');
            if ($archivo) {
                foreach ($productos as $producto) {
                    fwrite($archivo, "{$producto['codigo_producto']},{$producto['cantidad']}\n");
                }
                fclose($archivo);
                $_SESSION['productos_toma'] = [];
                $productos = &$_SESSION['productos_toma'];
                $success = "Toma física guardada en '{$nombre_archivo}'.";
            } else {
                $error = "Error al guardar el archivo.";
            }
        }
    } else {
        $error = "Debe agregar al menos un producto.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Toma Física de Inventarios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<div class="container mt-4">
    <h2>Toma Física de Inventario</h2>
    <!-- <p>Bienvenido, <?= htmlspecialchars($nombre) ?></p> -->

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php endif; ?>

    
    <form class="mb-3" method="get">
        <label>Código de Producto:</label>
        <input type="text" name="codigo_producto" required value="<?= htmlspecialchars($codigo_producto) ?>">
        <button class="btn btn-primary">Buscar</button>
    </form>

    <?php if ($codigo_producto && $detalle_producto): ?>
        <form method="post" class="mb-3">
            <p><strong><?= htmlspecialchars($detalle_producto) ?> (<?= htmlspecialchars($codigo_producto) ?>)</strong></p>
            <input type="number" name="cantidad" value="1" min="1" required>
            <input type="hidden" name="codigo_producto" value="<?= htmlspecialchars($codigo_producto) ?>">
            <input type="hidden" name="action" value="add_product">
            <button class="btn btn-success">Agregar</button>
        </form>
    <?php endif; ?>

    <?php if (!empty($productos)): ?>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Código</th>
                    <th>Detalle</th>
                    <th>Cantidad</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($productos as $index => $producto): ?>
                    <tr>
                        <td><?= htmlspecialchars($producto['codigo_producto']) ?></td>
                        <td><?= htmlspecialchars($producto['detalle_producto']) ?></td>
                        <td><?= htmlspecialchars($producto['cantidad']) ?></td>
                        <td>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="action" value="remove_product">
                                <input type="hidden" name="product_index" value="<?= $index ?>">
                                <button class="btn btn-danger btn-sm">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <form method="post">
            <input type="hidden" name="action" value="save_order">
            <button class="btn btn-primary">Guardar Toma Física</button>
        </form>
    <?php endif; ?>
</div>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>