<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];

// Incluir el archivo de conexión
include 'includes/conexion.php';

// Verificar si se ha enviado el formulario completo
// if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['archivo']) && $_FILES['archivo']['error'] == 0 && isset($_POST['proveedor'])) {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['archivo_txt']) && isset($_POST['proveedor'])) {
    // Obtener y validar ID del proveedor
    $idProveedor = (int)$_POST['proveedor'];
    if ($idProveedor <= 0) {
        header("Location: cargar_archivo.php?error=invalid_provider");
        exit;
    }

    // Leer y procesar el archivo
    //$contenidoArchivo = file_get_contents($_FILES['archivo']['tmp_name']);
    $archivoSeleccionado = basename($_POST['archivo_txt']);
$contenidoArchivo = file_get_contents(__DIR__ . '/archivos/' . $archivoSeleccionado);
    $bloques = explode('-----------------------------', $contenidoArchivo);
    
    $datosProcesados = [];
    $errores = [];

    foreach ($bloques as $bloque) {
        $bloque = trim($bloque);
        if (!empty($bloque)) {
            // Extraer datos con expresiones regulares
            $codigo = $detalle = $cantidad = null;
            preg_match('/Código\s*:\s*(\d+)/', $bloque, $matches) && $codigo = $matches[1];
            preg_match('/Detalle\s*:\s*([^\r\n]+)/', $bloque, $matches) && $detalle = trim($matches[1]);
            preg_match('/Cantidad\s*:\s*(\d+)/', $bloque, $matches) && $cantidad = $matches[1];

            if ($codigo && $detalle && $cantidad) {
                $datosProcesados[] = [
                    'codigo' => $codigo,
                    'detalle' => $detalle,
                    'cantidad' => $cantidad
                ];
            } else {
                $errores[] = "Bloque incompleto: " . substr($bloque, 0, 50) . "...";
            }
        }
    }

    // Redireccionar según resultados
    if (!empty($datosProcesados)) {
        // Guardar datos en sesión temporalmente como respaldo
        $_SESSION['temp_upload_data'] = [
            'datos' => $datosProcesados,
            'id_proveedor' => $idProveedor
        ];
        
        // Redirigir con los datos serializados
        header("Location: mostrar_resultados.php?datos=" . urlencode(serialize($datosProcesados)) . "&id_proveedor=" . $idProveedor);
        exit();
    } else {
        $_SESSION['upload_errors'] = $errores;
        header("Location: cargar_archivo.php?error=no_data");
        exit();
    }
} else {
    // Datos del formulario incompletos
    $errorType = !isset($_FILES['archivo']) ? 'no_file' : (!isset($_POST['proveedor']) ? 'no_provider' : 'file_error');
    header("Location: cargar_archivo.php?error=" . $errorType);
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Inventario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css"> <!-- Aquí se cargaría el archivo de estilos CSS -->
    <style>
        body {
            padding-top: 56px; /* Para asegurar que el contenido no se superponga a la barra de navegación */
        }
    </style>
</head>
<body>

<!-- Navbar similar a la primera página -->
<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<!-- Contenido principal -->
<div class="container mt-5">
    <?php
    if (isset($_GET['error']) && $_GET['error'] == 'no_data') {
        echo '<div class="alert alert-warning mt-3">No se encontraron datos en el archivo.</div>';
    }
    ?>

    <!-- Formulario para cargar el archivo -->
    <form action="procesar_archivo.php" method="POST" enctype="multipart/form-data">
        <div class="mb-3">
            <label for="archivo" class="form-label">Selecciona un archivo</label>
            <input type="file" name="archivo" id="archivo" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-primary">Cargar archivo</button>
    </form>
</div>



<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>