<?php
// Obtener los datos del archivo procesado
$datos = unserialize(urldecode($_GET['datos']));

session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

// Conexión a la base de datos (ajusta estos valores según tu configuración)
include 'includes/conexion.php'; // Asumo que tienes un archivo con la conexión

// Obtener el ID del proveedor (deberías pasarlo desde la página anterior)
$idProveedor = isset($_GET['id_proveedor']) ? (int)$_GET['id_proveedor'] : 0;


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resultados de Inventario</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<div class="container mt-5">
    <h3>Resultados de la carga del archivo</h3>
    
    <!-- Mostrar tabla de datos -->
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Código Almacén</th>
                <th>Código Proveedor</th>
                <th>Detalle</th>
                <th>Cantidad</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            foreach ($datos as $dato): 
                // Consultar el código del proveedor para este artículo
                $stmt = $pdo->prepare("SELECT CodigoProveedor FROM codigoproveedor 
                                       WHERE CodigoAlmacen = ? AND IdProveedor = ?");
                $stmt->execute([$dato['codigo'], $idProveedor]);
                $codigoProveedor = $stmt->fetchColumn();
            ?>
            <tr>
                <td><?= htmlspecialchars($dato['codigo']) ?></td>
                <td><?= htmlspecialchars($codigoProveedor ?: 'No encontrado') ?></td>
                <td><?= htmlspecialchars($dato['detalle']) ?></td>
                <td><?= htmlspecialchars($dato['cantidad']) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Botón para generar PDF (actualizado para incluir el ID del proveedor) -->
    <br><a href="generar_pdf.php?datos=<?= urlencode(serialize($datos)) ?>&id_proveedor=<?= $idProveedor ?>" 
          class="btn btn-primary">Generar PDF</a>
</div>


<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>