<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];

$directorio = __DIR__ . '/archivos';
$mostrar_resultados = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fecha_inicio = strtotime($_POST['fecha_inicio'] ?? '');
    $fecha_fin = strtotime($_POST['fecha_fin'] . ' 23:59:59');
    $mostrar_resultados = true;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Archivos por Fecha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Bootstrap y estilos -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css">
</head>
<body>

    <!-- Navbar similar a la primera página -->
    <nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<!-- Contenido principal -->
<div class="container mt-5">
    <h2 class="mb-4">Buscar Archivos por Rango de Fechas</h2>

    <!-- Formulario -->
    <form method="post" class="row g-3 mb-4">
        <div class="col-md-5">
            <label for="fecha_inicio" class="form-label">Fecha inicio</label>
            <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" required>
        </div>
        <div class="col-md-5">
            <label for="fecha_fin" class="form-label">Fecha fin</label>
            <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" required>
        </div>
        <div class="col-md-2 align-self-end">
            <button type="submit" class="btn btn-primary w-100"><i class="bi bi-search"></i> Buscar</button>
        </div>
    </form>

    <!-- Resultados -->
    <?php if ($mostrar_resultados): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-light">
                    <tr>
                        <th>Nombre del archivo</th>
                        <th>Última modificación</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $hay_resultados = false;
                    if (is_dir($directorio)) {
                        if ($gestor = opendir($directorio)) {
                            while (($archivo = readdir($gestor)) !== false) {
                                if ($archivo != "." && $archivo != "..") {
                                    $ruta = $directorio . '/' . $archivo;
                                    if (is_file($ruta)) {
                                        $fecha = filemtime($ruta);
                                        if ($fecha >= $fecha_inicio && $fecha <= $fecha_fin) {
                                            $hay_resultados = true;
                                            // echo '<tr>
                                            //     <td>' . htmlspecialchars($archivo) . '</td>
                                            //     <td>' . date("Y-m-d H:i:s", $fecha) . '</td>
                                            //     <td>
                                            //         <a href="archivos/' . urlencode($archivo) . '" class="btn btn-sm btn-outline-primary" download>
                                            //             <i class="bi bi-download"></i> Descargar
                                            //         </a>
                                            //     </td>
                                            // </tr>';
                                            echo '<tr>
    <td>' . htmlspecialchars($archivo) . '</td>
    <td>' . date("Y-m-d H:i:s", $fecha) . '</td>
    <td>
        <a href="archivos/' . urlencode($archivo) . '" class="btn btn-sm btn-outline-primary me-1" download>
            <i class="bi bi-download"></i> Descargar
        </a>
        <form action="generar_pdf.php" method="post" class="d-inline">
            <input type="hidden" name="archivo" value="' . htmlspecialchars($archivo) . '">
            <button type="submit" class="btn btn-sm btn-outline-danger">
                <i class="bi bi-file-earmark-pdf"></i> PDF
            </button>
        </form>
    </td>
</tr>';
                                        }
                                    }
                                }
                            }
                            closedir($gestor);
                        }
                    }

                    if (!$hay_resultados) {
                        echo '<tr><td colspan="3" class="text-center text-muted">No se encontraron archivos en el rango indicado.</td></tr>';
                    }
                    ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>