<?php
require('fpdf/fpdf.php');

// Validar los datos enviados por POST
if ($_SERVER['REQUEST_METHOD'] == 'POST' &&
    isset($_POST['codigo_producto'], $_POST['detalle_producto'], $_POST['precio'])) {
    
    $codigo = $_POST['codigo_producto'];
    $detalle = $_POST['detalle_producto'];
    $precio = number_format(floatval($_POST['precio']), 2, ',', '.');

    // Crear nuevo PDF (70 mm de ancho máximo y alto de 70 mm)
    $pdf = new FPDF('P', 'mm', array(70, 70));
    $pdf->AddPage();

    // Establecer márgenes a 5 mm
    $pdf->SetMargins(5, 5, 5);
    
    // Código del producto alineado a la izquierda
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 5, utf8_decode("Código: $codigo"), 0, 1, 'L');


    // Detalle del producto alineado a la izquierda
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->MultiCell(0, 5, utf8_decode("Producto: $detalle"), 0, 'L');

    // Espacio antes del precio
    $pdf->Ln(2);

    // Precio con control de tamaño si es muy largo
    $precio_texto = "CRC $precio";
    if (strlen($precio_texto) > 15) {
        $pdf->SetFont('Arial', 'B', 14);
    } else {
        $pdf->SetFont('Arial', 'B', 14);
    }

    // Precio centrado
    $pdf->Cell(0, 6, utf8_decode($precio_texto), 0, 1, 'C');

    // Salida del PDF
    $pdf->Output('I', "etiqueta_$codigo.pdf");
 
exit;
    exit;
} else {
    echo "Datos incompletos para generar la etiqueta.";
}
?>