<?php
// Incluir el archivo de conexión
include 'includes/conexion.php';
//include 'header.php';  // Incluye el archivo del header

session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}



// Variables para los detalles del producto
$codigo_producto = $detalle_producto = '';
$existencia = 0;

// Buscar producto por código
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['codigo_producto'])) {
    $codigo_producto = $_GET['codigo_producto'];

    if (!empty($codigo_producto)) {
        // Consultar producto por código
        $stmt = $pdo->prepare("SELECT * FROM productos WHERE Codigo = :codigo_producto");
        $stmt->bindParam(':codigo_producto', $codigo_producto);
        $stmt->execute();
        
        $producto = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($producto) {
            $detalle_producto = $producto['Detalle'];
            $existencia = $producto['Existencia'];
        } else {
            $error = "Producto no encontrado.";
        }
    }
}

// Actualizar existencia del producto
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['codigo_producto'])) {
    $codigo_producto = $_POST['codigo_producto'];
    $existencia = $_POST['existencia'];

    // Validar que existencia sea un número válido y mayor o igual a 0
    if (!empty($codigo_producto) && isset($existencia) && is_numeric($existencia) && $existencia >= 0) {
        // Actualizar la existencia en la base de datos
        $stmt = $pdo->prepare("UPDATE productos SET Existencia = :existencia WHERE Codigo = :codigo_producto");
        $stmt->bindParam(':codigo_producto', $codigo_producto);
        $stmt->bindParam(':existencia', $existencia);

        if ($stmt->execute()) {
            $success = "Existencia actualizada exitosamente.";
        } else {
            $error = "Error al actualizar existencia.";
        }
    } else {
        // Si el valor de existencia no es válido, asignar un valor por defecto
        $error = "La existencia debe ser un valor numérico no negativo.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Productos</title>
    <!-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet"> -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <!-- Aquí llamamos al archivo CSS -->
   <link rel="stylesheet" href="css/estilos.css">    
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<!-- Contenido principal -->
<div class="container mt-5">
    <h2 class="mb-4">Gestión de Productos</h2>

    <!-- Formulario de búsqueda -->
    <form action="gestion_productos.php" method="get" class="mb-4">
        <div class="mb-3">
            <label for="codigo_producto" class="form-label">Código de Producto</label>
            <input type="text" class="form-control" id="codigo_producto" name="codigo_producto" value="<?php echo htmlspecialchars($codigo_producto); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary-custom">Buscar</button>
    </form>

    <?php if (isset($error)) : ?>
        <div class="alert alert-danger mt-3"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <!-- Mostrar detalles del producto -->
    <?php if (!empty($codigo_producto) && isset($detalle_producto)) : ?>
        <div class="card mb-4">
            <div class="card-body">
                <h4 class="card-title">Detalles del Producto</h4>
                <form action="gestion_productos.php" method="post">
                    <div class="mb-3">
                        <label for="detalle_producto" class="form-label">Detalle del Producto</label>
                        <input type="text" class="form-control" id="detalle_producto" value="<?php echo htmlspecialchars($detalle_producto); ?>" disabled>
                    </div>
                    <div class="mb-3">
                        <label for="existencia" class="form-label">Existencia</label>
                        <input type="number" class="form-control" id="existencia" name="existencia" value="<?php echo htmlspecialchars($existencia); ?>" min="0" required>
                    </div>
                    <input type="hidden" name="codigo_producto" value="<?php echo htmlspecialchars($codigo_producto); ?>">
                    <button type="submit" class="btn btn-success btn-primary-custom">Actualizar Existencia</button>

                </form>
            </div>
        </div>
    <?php endif; ?>

    <?php if (isset($success)) : ?>
        <div class="alert alert-success mt-3"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>