<?php
include 'includes/config.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}
$nombre = $_SESSION['user_name'];
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Cargar Archivo y Generar PDF</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css">
</head>

<body>
<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<div class="container mt-5">
    <h2 class="mb-4">Cargar Archivo y Generar PDF</h2>

    <form action="procesar_archivo.php" method="POST" enctype="multipart/form-data" class="mb-4">
        <div class="mb-3">
            <label for="buscarProveedor" class="form-label">Buscar Proveedor</label>
            <input type="text" id="buscarProveedor" name="buscarProveedor" onkeyup="buscarProveedores()" placeholder="Escribe el nombre del proveedor..." class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="proveedor" class="form-label">Seleccionar Proveedor</label>
            <select name="proveedor" id="proveedor" class="form-select" required>
                <option value="">Selecciona un proveedor</option>
            </select>
        </div>

        <div id="detallesProveedor" style="margin-top: 20px;"></div>

        <!-- Filtro por fecha -->
        <div class="row mb-3">
            <div class="col-md-6">
                <label for="fecha_desde" class="form-label">Desde</label>
                <input type="date" id="fecha_desde" class="form-control">
            </div>
            <div class="col-md-6">
                <label for="fecha_hasta" class="form-label">Hasta</label>
                <input type="date" id="fecha_hasta" class="form-control">
            </div>
        </div>

        <!-- Selector de archivo TXT -->
        <div class="mb-3">
            <label for="archivo_txt" class="form-label">Seleccionar archivo TXT</label>
            <select name="archivo_txt" id="archivo_txt" class="form-select" required>
                <option value="">Seleccione un archivo</option>
            </select>
        </div>

        <button type="submit" class="btn btn-primary btn-custom">Cargar y Generar PDF</button>
    </form>
</div>

<script>
function buscarProveedores() {
    var textoBusqueda = document.getElementById('buscarProveedor').value;
    if (textoBusqueda.length > 2) {
        $.ajax({
            url: 'buscar_proveedor.php',
            type: 'GET',
            data: { busqueda: textoBusqueda },
            success: function(response) {
                document.getElementById('proveedor').innerHTML = response;
            }
        });
    } else {
        document.getElementById('proveedor').innerHTML = '<option value="">Selecciona un proveedor</option>';
    }
}

function cargarArchivosPorFecha() {
    const desde = document.getElementById('fecha_desde').value;
    const hasta = document.getElementById('fecha_hasta').value;

    $.ajax({
        url: 'filtrar_archivos_por_fecha.php',
        type: 'GET',
        data: {
            desde: desde,
            hasta: hasta
        },
        success: function(response) {
            document.getElementById('archivo_txt').innerHTML = response;
        }
    });
}

document.getElementById('fecha_desde').addEventListener('change', cargarArchivosPorFecha);
document.getElementById('fecha_hasta').addEventListener('change', cargarArchivosPorFecha);
</script>

<?php include 'footer.php'; ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>