<?php
require('fpdf/fpdf.php');

// Obtener los datos del archivo TXT pasados por GET
$datos = isset($_GET['datos']) ? unserialize(urldecode($_GET['datos'])) : [];
$idProveedor = isset($_GET['id_proveedor']) ? (int)$_GET['id_proveedor'] : 0;

// Validar que hay datos
if (empty($datos)) {
    die('Error: No se recibieron datos para generar el PDF');
}

// Conexión a la base de datos para obtener los datos de la empresa y proveedor
include('includes/conexion.php');

// Obtener los datos de la empresa
$stmt = $pdo->prepare("SELECT * FROM empresa WHERE Id = '1'"); // Asumí que el Id de la empresa es '1', ajusta según corresponda
$stmt->execute();
$empresa = $stmt->fetch(PDO::FETCH_ASSOC);

// Verificar si se obtuvieron datos de la empresa
if (!$empresa) {
    die('Error: No se encontraron datos de la empresa');
}

// Obtener los datos del proveedor
$stmtProveedor = $pdo->prepare("SELECT NombreComercial FROM proveedores WHERE Id = ?");
$stmtProveedor->execute([$idProveedor]);
$proveedor = $stmtProveedor->fetch(PDO::FETCH_ASSOC);

// Verificar si se obtuvo el nombre del proveedor
if (!$proveedor) {
    die('Error: No se encontraron datos del proveedor');
}

// Crear un nuevo documento PDF
$pdf = new FPDF();
$pdf->AddPage();

// Encabezado de la empresa (Cargar desde la base de datos)
$pdf->SetFont('Arial', 'B', 14);
$pdf->SetTextColor(0, 0, 128); // Azul para un toque profesional
$pdf->Cell(0, 10, strtoupper($empresa['NombreComercial']), 0, 1, 'C');
$pdf->SetFont('Arial', 'I', 10);
$pdf->SetTextColor(0, 0, 0); // Texto negro
$pdf->Cell(0, 10, 'Cedula: ' . $empresa['Cedula'], 0, 1, 'C');
$pdf->Cell(0, 10, 'Telefono: ' . $empresa['Telefono'], 0, 1, 'C');
$pdf->Cell(0, 10, 'Direccion: ' . $empresa['Direccion1'] . ', ' . $empresa['Barrio'] . ', ' . $empresa['Provincia'], 0, 1, 'C');
$pdf->Ln(5); // Salto de línea adicional

// Agregar el nombre del proveedor en el encabezado
$pdf->SetFont('Arial', 'B', 12);
$pdf->SetTextColor(0, 0, 0); // Texto negro
$pdf->Cell(0, 10, 'Proveedor: ' . $proveedor['NombreComercial'], 0, 1, 'C');
$pdf->Ln(5); // Salto de línea adicional

// Título de la tabla
$pdf->SetFont('Arial', 'B', 12);
$pdf->SetFillColor(0, 0, 128); // Fondo azul para el encabezado
$pdf->SetTextColor(255, 255, 255); // Texto blanco
$pdf->Cell(50, 10, 'Codigo', 1, 0, 'C', true);
$pdf->Cell(80, 10, 'Detalle', 1, 0, 'C', true);
$pdf->Cell(30, 10, 'Cantidad', 1, 1, 'C', true);

// Datos de la tabla
$pdf->SetFont('Arial', '', 10);
$pdf->SetTextColor(0, 0, 0); // Texto negro para los datos

foreach ($datos as $dato) {
    // Consultar código de proveedor
    $stmt = $pdo->prepare("SELECT CodigoProveedor FROM codigoproveedor 
                          WHERE CodigoAlmacen = ? AND IdProveedor = ?");
    $stmt->execute([$dato['codigo'], $idProveedor]);
    $codigoProveedor = $stmt->fetchColumn();
    
    // Agregar las filas con bordes y un poco de relleno
    $pdf->Cell(50, 10, $codigoProveedor ?: 'N/A', 1, 0, 'C');
    $pdf->Cell(80, 10, iconv('UTF-8', 'windows-1252', $dato['detalle']), 1, 0, 'L');
    $pdf->Cell(30, 10, $dato['cantidad'], 1, 1, 'C');
}

// Línea de cierre
$pdf->Ln(10);
$pdf->SetFont('Arial', 'I', 8);
$pdf->Cell(0, 10, 'Generado por: ' . $empresa['NombreComercial'] . ' - ' . date('Y-m-d H:i:s'), 0, 1, 'C');

// Salida del PDF
$pdf->Output('I', 'inventario_proveedor_'.$idProveedor.'.pdf');
?>