<?php
// Incluir el archivo de conexión
include 'includes/conexion.php';
//include 'header.php'; // Incluye el archivo del header

session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$nombre = $_SESSION['user_name'];
// No es necesario repetir la validación de sesión aquí, ya se hizo arriba.
// if (!isset($_SESSION['user_id'])) {
//     header("Location: index.php");
//     exit;
// }


// Variables para los detalles del producto
$codigo_producto = $detalle_producto = '';
$precio = 0;
$error = ''; // Inicializar la variable de error
$success = ''; // Inicializar la variable de éxito

// Buscar producto por código
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['codigo_producto'])) {
    $codigo_producto = $_GET['codigo_producto'];

    if (!empty($codigo_producto)) {
        // Consultar producto por código
        $stmt = $pdo->prepare("SELECT * FROM productos WHERE Codigo = :codigo_producto");
        $stmt->bindParam(':codigo_producto', $codigo_producto);
        $stmt->execute();

        $producto = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($producto) {
            $detalle_producto = $producto['Detalle'];
            $precio = $producto['Pvp'];
        } else {
            $error = "Producto no encontrado.";
            $codigo_producto = ''; // Limpiar si no se encuentra
        }
    } else {
        $error = "Por favor, ingresa un código de producto.";
    }
}

// El bloque POST para "actualizar existencia" que tenías comentado no es necesario aquí para generar etiquetas.
// Si deseas actualizar el precio desde este formulario, ese bloque necesitaría un `UPDATE` real.
// Para la generación de etiquetas, solo necesitamos los datos para enviarlos.

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Etiquetas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <link rel="stylesheet" href="css/estilos.css">
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="#">Gestión de Inventario</a>
        <div>
            <span class="welcome-msg me-3">Bienvenido, <?= htmlspecialchars($nombre) ?></span>
            <a href="dashboard.php" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-box-arrow-right"></i> Volver
            </a>
        </div>
    </div>
</nav>

<div class="container mt-5">
    <h2 class="mb-4">Generar Etiquetas de Productos</h2>

    <form action="generar_etiquetas.php" method="get" class="mb-4">
        <div class="mb-3">
            <label for="codigo_producto" class="form-label">Código de Producto</label>
            <input type="text" class="form-control" id="codigo_producto" name="codigo_producto" value="<?php echo htmlspecialchars($codigo_producto); ?>" required>
        </div>
        <button type="submit" class="btn btn-primary-custom">Buscar</button>
    </form>

    <?php if (!empty($error)) : ?>
        <div class="alert alert-danger mt-3"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if (!empty($success)) : ?>
        <div class="alert alert-success mt-3"><?php echo htmlspecialchars($success); ?></div>
    <?php endif; ?>

    <?php if (!empty($codigo_producto) && isset($detalle_producto) && empty($error)) : // Solo muestra si hay un producto y no hay errores de búsqueda ?>
        <div class="card mb-4">
            <div class="card-body">
                <h4 class="card-title">Detalles del Producto Encontrado</h4>
                <form action="imprimir_etiqueta.php" method="post" target="_blank">
                    <div class="mb-3">
                        <label for="detalle_producto_display" class="form-label">Detalle del Producto</label>
                        <input type="text" class="form-control" id="detalle_producto_display" value="<?php echo htmlspecialchars($detalle_producto); ?>" disabled>
                    </div>
                    <div class="mb-3">
                        <label for="precio_display" class="form-label">Precio</label>
                        <input type="text" class="form-control" id="precio_display" value="<?php echo number_format($precio, 2, ',', '.'); ?>" disabled>
                    </div>
                    <input type="hidden" name="codigo_producto" value="<?php echo htmlspecialchars($codigo_producto); ?>">
                    <input type="hidden" name="detalle_producto" value="<?php echo htmlspecialchars($detalle_producto); ?>">
                    <input type="hidden" name="precio" value="<?php echo htmlspecialchars($precio); ?>">
                    <button type="submit" class="btn btn-success btn-primary-custom">Generar Etiqueta para Imprimir</button>
                </form>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>