<?php
include 'includes/conexion.php';

// Verificar si se ha enviado una búsqueda
if (isset($_GET['busqueda'])) {
    $busqueda = '%' . $_GET['busqueda'] . '%'; // Búsqueda flexible

    // Consultar proveedores que coincidan con la búsqueda
    $stmt = $pdo->prepare("SELECT Id, NombreComercial, Cedula FROM proveedores WHERE NombreComercial LIKE :busqueda OR Cedula LIKE :busqueda");
    $stmt->execute(['busqueda' => $busqueda]);

    // Si encontramos proveedores, los mostramos en formato <option>
    if ($stmt->rowCount() > 0) {
        echo '<option value="">Selecciona un proveedor</option>';
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            echo "<option value='{$row['Id']}'>{$row['NombreComercial']} ({$row['Cedula']})</option>";
        }
    } else {
        echo '<option value="">No se encontraron proveedores</option>';
    }
}
?>